/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.host;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Host;
import com.pageseeder.host.HostErrorID;
import com.pageseeder.host.Hosts;
import com.pageseeder.mail.MailHosts;
import java.io.IOException;

@Requires(parameters={"name"})
@Output(types={OutputType.XML, OutputType.JSON})
public class CreateHost
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        Transaction tr = req.getTransaction();
        String newHostName = req.getParameter((Parameter)StandardParameters.name);
        boolean external = req.getParameter((Parameter)StandardParameters.external, false);
        boolean virtual = req.getParameter((Parameter)StandardParameters.virtual, false);
        if (!Hosts.checkHostName(newHostName = newHostName.toLowerCase(), res)) {
            return;
        }
        if (DatabaseQuery.getHostByName((Database)db, (String)newHostName) != null || DatabaseQuery.getHostAliasByName((Database)db, (String)newHostName) != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)HostErrorID.NAME_ALREADY_EXISTS, "The host name is already in use.");
            return;
        }
        if (virtual && !external) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Only external hosts can be created as virtual.");
            return;
        }
        Host newHost = Host.create((Database)db);
        newHost.setName(newHostName);
        if (external) {
            newHost.setExternal(Boolean.TRUE);
        }
        if (virtual) {
            newHost.setVirtual(Boolean.TRUE);
        }
        newHost = newHost.insert(db);
        if (!external) {
            MailHosts.clearInternalHosts();
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("host-creation");
        out.writeHost(newHost);
        out.endObject();
        out.flush();
    }
}

