/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.host;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import java.io.IOException;

@Output(types={OutputType.JSON, OutputType.XML})
public class CheckCurrentHost
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, QueryFailedException {
        Database db = req.getDatabase();
        String hostname = req.getHttpServletRequest().getServerName();
        hostname = hostname.toLowerCase();
        while (hostname.endsWith(".")) {
            hostname = hostname.substring(0, hostname.length() - 1);
        }
        String status = "not-found";
        if (DatabaseQuery.getHostByName((Database)db, (String)hostname) != null) {
            status = "host-found";
        } else if (DatabaseQuery.getHostAliasByName((Database)db, (String)hostname) != null) {
            status = "alias-found";
        } else if (DatabaseQuery.getAllHostsAlpha((Database)db, (boolean)false, (int)1, (int)1, (boolean)false).isEmpty()) {
            status = "no-hosts";
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("check-host");
        out.field("status", status);
        out.endObject();
        out.flush();
    }
}

