/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.groupfolder;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.MD5;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.GroupURIs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ListGroupFolders
implements Generator,
SingleCheck,
Cacheable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListGroupFolders.class);
    private static final Comparator<GroupURI> PATH_ALPHABETICAL_ORDER = (guri1, guri2) -> {
        if (guri1 == null) {
            return -1;
        }
        if (guri2 == null) {
            return 1;
        }
        return guri1.getPath().compareTo(guri2.getPath());
    };

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewGroupCheck(req.getGroup()));
        }
        return new ViewGroupCheck(req.getGroup());
    }

    public String getETag(GeneratorRequest req) {
        Member m;
        boolean owned = req.getParameter((Parameter)StandardParameters.owned, true);
        boolean sharing = req.getParameter((Parameter)StandardParameters.sharing, true);
        Member member = m = req.getMember() == null ? req.getAuthenticatedMember() : req.getMember();
        if (owned || m != null && sharing) {
            return null;
        }
        StringBuilder etag = new StringBuilder();
        for (GroupURI guri : req.getGroup().getGroupURIsCol()) {
            etag.append(GroupURIRule.buildLocalHashSource((GroupURI)guri)).append('|');
        }
        return MD5.hash((String)etag.toString());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        boolean owned = req.getParameter((Parameter)StandardParameters.owned, true);
        boolean sharing = req.getParameter((Parameter)StandardParameters.sharing, true);
        Database db = req.getDatabase();
        Group group = req.getGroup();
        Member member = req.getMember() == null ? req.getAuthenticatedMember() : req.getMember();
        GroupURI dguri = GroupURIRule.getDefaultGroupURI((Group)group);
        List<Object> guris = owned && dguri != null && !GroupRule.isProject((Group)group) ? DatabaseQuery.getGroupURIsBySchemeHostPortSubpathGroup((Database)db, (String)dguri.getScheme(), (String)dguri.getHost().getName(), (Integer)dguri.getPort(), (String)GroupURIs.truncatePath((String)dguri.getPath()), (Long)group.getId()) : new ArrayList<GroupURI>(group.getGroupURIsCol());
        guris.sort(PATH_ALPHABETICAL_ORDER);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("groupfolders");
        UserDetails userdetails = null;
        if (member != null && sharing) {
            userdetails = new UserDetailsManager().get(db, member.getId());
        }
        out.startCollection("groupfolders", OutputPrinter.CollectionOption.JSON_ONLY);
        for (GroupURI guri : guris) {
            Boolean shared = null;
            if (!guri.isExternal()) {
                try {
                    shared = GroupURIRule.isShared((Database)db, (GroupURI)guri) || !guri.getPath().startsWith(GlobalSettings.getSitePrefix() + "/" + group.getName().replace('-', '/') + "/");
                }
                catch (QueryFailedException ex) {
                    LOGGER.error("Failed to load shared groups for GroupURI {}", (Object)guri.getId(), (Object)ex);
                }
            }
            if (GroupURIRule.isGeneralGroupURI((GroupURI)guri, (Group)group) || guri.getPath().endsWith("%") || shared != null && !shared.booleanValue() && !GroupURIRule.isDefaultGroupURI((GroupURI)guri, (Group)group)) continue;
            if (userdetails != null) {
                out.writeGroupFolder(guri, false, shared);
                out.writeGroupFolderSharingDetails(guri, userdetails, db);
                out.endObject();
                continue;
            }
            out.writeGroupFolder(guri, true, shared);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

