/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.groupfolder;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.groupfolder.GroupFolderErrorID;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;

final class GroupFolders {
    public static @Nullable Collection<Group> checkGroups(GeneratorResponse res, Database db, String tgroups, Group owner, @Nullable Collection<Group> cur_groups, boolean shared, Long memberid, UserDetails userdetails) throws QueryFailedException {
        ArrayList<Group> grpc = new ArrayList<Group>();
        String[] groupnames = null;
        Permissions perm = new Permissions();
        if (tgroups != null && !tgroups.isEmpty()) {
            for (String groupname : groupnames = tgroups.split(",")) {
                Group grp = DatabaseQuery.getGroupByName((Database)db, (String)groupname);
                if (grp == null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.INVALID_GROUP, "Invalid group name: " + groupname);
                    return null;
                }
                if (GroupRule.isPublicGroup((String)grp.getName()) || GroupRule.isAdminGroup((String)grp.getName())) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.INVALID_GROUP, "Invalid group name: " + groupname);
                    return null;
                }
                if (grpc.contains(grp)) continue;
                if (owner != null && grp.equals((Object)owner)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.OWNER_GROUP, "The groups parameter can not contain the owner group " + owner.getName());
                    return null;
                }
                if (!PermissionManager.check((Long)memberid, (UserDetails)userdetails, (Database)db, (Permissions)perm, (PermissionCheck)new ConfigureProjectCheck(grp))) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.INVALID_GROUP, "You must be the project manager of the group " + grp.getName());
                    return null;
                }
                if (cur_groups != null) {
                    if (!cur_groups.contains(grp) && shared) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.ID_NOT_IN_GROUP, "The group folder ID is not shared to group " + grp.getName());
                        return null;
                    }
                    if (cur_groups.contains(grp) && !shared) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.GROUP_FOLDER_EXISTS, "The group folder is already shared to group " + grp.getName());
                        return null;
                    }
                }
                grpc.add(grp);
            }
        }
        return grpc;
    }
}

