/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.groupfolder;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.GroupURIForGroup;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.groupfolder.GroupFolderErrorID;
import com.pageseeder.groupfolder.GroupFolders;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

@Requires(database=true, member=true, group=true, parameters={"id"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class EditGroupFolder
implements Generator,
SingleCheck {
    private static final String PUBLIC_GROUP = "public";

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ConfigureProjectCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        Group group = req.getGroup();
        Long id = req.getParameter("id", -1L);
        String publicString = req.getParameter((Parameter)StandardParameters.public_);
        String groups = req.getParameter((Parameter)StandardParameters.groups);
        String editgroups = req.getParameter((Parameter)StandardParameters.editgroups);
        GroupURI guri = DatabaseQuery.getGroupURIById((Database)db, (Long)id);
        if (guri == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)GroupFolderErrorID.INVALID_ID);
            return;
        }
        if (GroupRule.isProject((Group)group)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.INVALID_GROUP, group.getName() + " is a project");
            return;
        }
        Member member = req.getMember();
        UserDetailsManager user_manager = new UserDetailsManager();
        UserDetails userdetails = user_manager.get(db, member.getId());
        Long memberid = req.getMember().getId();
        Group owner = GroupURIRule.getDefaultGroup((Database)db, (GroupURI)guri);
        Collection<Group> grpc = GroupFolders.checkGroups(res, db, groups, owner, null, false, memberid, userdetails);
        if (grpc == null) {
            return;
        }
        Collection<Group> editgrpc = GroupFolders.checkGroups(res, db, editgroups, owner, null, false, memberid, userdetails);
        if (editgrpc == null) {
            return;
        }
        if (owner == null || !owner.equals((Object)group)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.GROUP_FOLDER_NOT_OWNED, "Group folder not owned by group " + group.getName());
            return;
        }
        ChangesManager changes = ChangesManager.getInstance();
        Group pgroup = DatabaseQuery.getGroupByName((Database)db, (String)PUBLIC_GROUP);
        ArrayList<Object> newgrpc = new ArrayList();
        ArrayList<Object> neweditgrpc = new ArrayList();
        ArrayList oldgrpc = new ArrayList();
        Collection cur_groups = guri.getGroupsCol();
        if (groups != null || editgroups != null) {
            if (grpc.removeAll(editgrpc)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.GROUP_IN_GROUPS_AND_EDITGROUPS);
                return;
            }
            if (!grpc.isEmpty() || !editgrpc.isEmpty() || "true".equals(publicString)) {
                GroupURI shared = GroupURIRule.getSharedAncestorOrDescendant((String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)guri.getPath(), (boolean)false, (Database)db);
                if (shared != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.ANCESTOR_SHARED_GROUP_FOLDER, "Cannot share group folder path " + guri.getPath() + " because of shared ancestor " + shared.getPath());
                    return;
                }
                shared = GroupURIRule.getSharedAncestorOrDescendant((String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)guri.getPath(), (boolean)true, (Database)db);
                if (shared != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.DESCENDANT_SHARED_GROUP_FOLDER, "Cannot share group folder path " + guri.getPath() + " because of shared descendant " + shared.getPath());
                    return;
                }
            }
            ArrayList existgrpc = new ArrayList(cur_groups);
            existgrpc.retainAll(grpc);
            for (Object grp : existgrpc) {
                GroupURIForGroup groupURIForGroup = DatabaseQuery.getGroupURIForGroupByGroupURI((Database)db, (GroupURI)guri, (Group)grp);
                if (groupURIForGroup == null) continue;
                groupURIForGroup.setEditURIs(Boolean.valueOf(false));
            }
            ArrayList existeditgrpc = new ArrayList(cur_groups);
            existeditgrpc.retainAll(editgrpc);
            for (Group group2 : existeditgrpc) {
                GroupURIForGroup gurifg = DatabaseQuery.getGroupURIForGroupByGroupURI((Database)db, (GroupURI)guri, (Group)group2);
                if (gurifg == null) continue;
                gurifg.setEditURIs(Boolean.valueOf(true));
            }
            newgrpc = new ArrayList<Group>(grpc);
            newgrpc.removeAll(cur_groups);
            for (Group group3 : newgrpc) {
                GroupURIRule.addGroupURIToGroup((Group)group3, (GroupURI)guri, (boolean)false, (Database)db);
            }
            neweditgrpc = new ArrayList<Group>(editgrpc);
            neweditgrpc.removeAll(cur_groups);
            for (Group group4 : neweditgrpc) {
                GroupURIRule.addGroupURIToGroup((Group)group4, (GroupURI)guri, (boolean)true, (Database)db);
            }
            oldgrpc = new ArrayList(cur_groups);
            oldgrpc.removeAll(grpc);
            oldgrpc.removeAll(editgrpc);
            oldgrpc.remove(owner);
            oldgrpc.remove(pgroup);
            for (Group group5 : oldgrpc) {
                group5.removeGroupURIs(guri);
            }
        }
        if (publicString != null) {
            boolean cur_pub = GroupURIRule.belongsToGroup((GroupURI)guri, (String)PUBLIC_GROUP);
            if ("true".equals(publicString) && !cur_pub) {
                GroupURIRule.addGroupURIToGroup((Group)pgroup, (GroupURI)guri, (boolean)false, (Database)db);
            } else if ("false".equals(publicString) && cur_pub) {
                pgroup.removeGroupURIs(guri);
            }
        }
        req.getTransaction().commitAndStart();
        Collection added_groups = guri.getGroupsCol();
        added_groups.removeAll(cur_groups);
        ArrayList removed_groups = new ArrayList(cur_groups);
        removed_groups.removeAll(guri.getGroupsCol());
        if (!added_groups.isEmpty() || !removed_groups.isEmpty()) {
            ChangesBatch batch = new ChangesBatch("Unsharing group folder " + guri.getPath());
            changes.startBatch(db, batch);
            ArrayList<Group> arrayList = new ArrayList<Group>(cur_groups);
            arrayList.retainAll(guri.getGroupsCol());
            arrayList.remove(pgroup);
            if (!arrayList.contains(owner)) {
                arrayList.add(owner);
            }
            changes.modifyGroupfolder(db, guri, arrayList);
            added_groups.remove(pgroup);
            removed_groups.remove(pgroup);
            if (!added_groups.isEmpty()) {
                changes.createGroupfolder(db, guri, added_groups);
            }
            if (!removed_groups.isEmpty()) {
                changes.deleteGroupfolder(db, guri.getId(), guri.getPath(), removed_groups);
            }
            Collection uris = DatabaseQuery.getURIsByGroupURI((Database)db, (GroupURI)guri);
            for (URI uri : uris) {
                if (!added_groups.isEmpty()) {
                    changes.createURI(db, batch, uri, added_groups);
                }
                if (URIRule.isFolder((URI)uri)) {
                    if (removed_groups.isEmpty()) continue;
                    changes.deleteFolder(db, batch, uri.getId(), uri.getDocID(), uri.getPath(), removed_groups);
                    continue;
                }
                if (removed_groups.isEmpty()) continue;
                changes.deleteDocument(db, batch, uri.getId(), uri.getDocID(), uri.getPath(), removed_groups);
            }
            changes.completeBatch(db, batch);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("groupfolder-modification");
        out.writeGroupFolder(guri, false, db);
        out.writeGroupFolderSharingDetails(guri, userdetails, db);
        out.endObject();
        out.endObject();
        out.flush();
    }
}

