/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ArchiveGroupCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.group.GroupErrorID;
import com.pageseeder.group.RenameGroupThread;
import java.io.IOException;

@Requires(group=true, database=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class UnarchiveGroup
implements Generator,
SingleCheck {
    @ContentPermission(value=ArchiveGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ArchiveGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        boolean hasParent;
        Database db = req.getDatabase();
        Group group = req.getGroup();
        if (group.getName().equals("archive") || !group.getName().startsWith("archive-")) {
            res.setError(GeneratorStatus.BAD_REQUEST, "This group con not be unarchived");
            return;
        }
        String newname = group.getName().replaceFirst("^archive-", "");
        boolean bl = hasParent = newname.indexOf(45) != -1;
        if (hasParent) {
            String name = newname.substring(0, newname.lastIndexOf(45));
            while (true) {
                Group project;
                try {
                    project = DatabaseQuery.getGroupByName((Database)db, (String)name);
                }
                catch (QueryFailedException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load parent project from DB: " + ex.getMessage());
                    return;
                }
                if (project == null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.PROJECT_MISSING, "Parent project " + name + " is missing");
                    return;
                }
                if (!GroupRule.isProject((Group)project)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.PROJECT_MISSING, "Parent project " + name + " is a group");
                    return;
                }
                if (name.indexOf(45) == -1) break;
                name = name.substring(0, name.lastIndexOf(45));
            }
        }
        boolean allgroups = "true".equals(req.getParameter((Parameter)StandardParameters.allgroups, "false"));
        boolean reindex = "true".equals(req.getParameter((Parameter)StandardParameters.index, "true"));
        RenameGroupThread thread = RenameGroupThread.unarchive(req.getMember().getUsername(), req.getGroup(), reindex, allgroups);
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("group-unarchive");
        thread.print((OutputPrinter)out);
        out.endObject();
        out.flush();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }
}

