/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupForGroup;
import com.pageseeder.db.model.Member;
import com.pageseeder.group.GroupErrorID;
import java.io.IOException;
import java.util.Collection;

@Requires(group=true, database=true, parameters={"subgroup"})
@Output(types={OutputType.JSON, OutputType.XML})
public final class RemoveSubgroup
implements Generator,
SingleCheck {
    @ContentPermission(value=EditGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new EditGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Long subgroupID;
        Database db = req.getDatabase();
        String subgroupIDorName = req.getParameter((Parameter)StandardParameters.subgroup);
        try {
            subgroupID = Long.parseLong(subgroupIDorName);
        }
        catch (NumberFormatException ex) {
            Group subgroup = DatabaseQuery.getGroupByName((Database)req.getDatabase(), (String)subgroupIDorName);
            if (subgroup == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_SUBGROUP_PARAMETER, "No group found with name or ID " + subgroupIDorName);
                return;
            }
            subgroupID = subgroup.getId();
        }
        GroupForGroup subgroup = DatabaseQuery.getGroupForGroupByMainGroupSubGroup((Database)req.getDatabase(), (Long)req.getGroup().getId(), (Long)subgroupID);
        if (subgroup == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_SUBGROUP_PARAMETER, "No subgroup found with group ID " + subgroupID);
            return;
        }
        subgroup.getGroup().removeGroupForGroup(subgroup);
        subgroup.delete(db);
        Collection members = DatabaseQuery.getMembersByGroupIdNoSubgroups((Database)db, (Long)subgroupID);
        UserDetailsManager details_manager = new UserDetailsManager();
        for (Member mem : members) {
            details_manager.remove(mem.getId());
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("subgroup-removal");
        out.endObject();
        out.flush();
    }
}

