/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

@Requires(database=true, member=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class ListVisibleGroups
implements Generator,
SingleCheck {
    private static final Comparator<Group> SORT_BY_GROUP_NAME = (g1, g2) -> g1.getName().compareTo(g2.getName());

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        Member m = req.getMember();
        ArrayList<String> registered = new ArrayList<String>();
        Collection mfgs = m.getGroupsForMemberCol((Object)Predicates.predicateMemberForGroupRegistered((Database)db, (boolean)false));
        for (Object mfg : mfgs) {
            registered.add(mfg.getGroup().getName());
        }
        Collection visible = DatabaseQuery.getGroupsByControlGroupNameCol((Database)db, (String)"public", (boolean)false);
        for (String string : registered) {
            visible.addAll(DatabaseQuery.getGroupsByControlGroupNameCol((Database)db, (String)string, (boolean)false));
        }
        ArrayList<Group> new_visible = new ArrayList<Group>();
        for (Group group : visible) {
            if (registered.contains(group.getName())) continue;
            new_visible.add(group);
        }
        new_visible.sort(SORT_BY_GROUP_NAME);
        UniversalPrinter universalPrinter = res.getUniversalWriter();
        universalPrinter.startObject("groups");
        universalPrinter.startCollection("groups", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Group group : new_visible) {
            universalPrinter.writeGroup(group, true, true, true, true);
        }
        universalPrinter.endCollection();
        universalPrinter.endObject();
        universalPrinter.flush();
    }
}

