/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMembersCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.model.GroupForGroup;
import java.io.IOException;

@Requires(group=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class ListSubgroups
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewMembersCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMembersCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("subgroups");
        out.startCollection("subgroups", OutputPrinter.CollectionOption.JSON_ONLY);
        for (GroupForGroup subgroup : req.getGroup().getMemberGroups()) {
            out.writeSubgroup(subgroup);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

