/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMembersCheck;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.MemberForGroup;
import java.io.IOException;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class GetGroupModerator
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewMembersCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMembersCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        MemberForGroup moderator = DatabaseQuery.getModeratorByGroupId((Database)req.getDatabase(), (Long)req.getGroup().getId());
        UniversalPrinter out = res.getUniversalWriter();
        if (moderator != null) {
            out.writeMembership(new Membership(moderator), null, MemberDetailsConfig.Visibility.GROUP, null);
        } else {
            out.startObject("no-moderator");
            out.endObject();
        }
        out.flush();
    }
}

