/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.CreateProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Requires(database=true, member=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class FindProjects
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 1000L;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if ("server".equals(req.getParameter((Parameter)StandardParameters.for_))) {
            return new CreateProjectCheck();
        }
        return new ViewMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        List<Group> groups;
        Database db = req.getDatabase();
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        String nameprefix = req.getParameter((Parameter)StandardParameters.nameprefix);
        String titleprefix = req.getParameter((Parameter)StandardParameters.titleprefix);
        String forParam = req.getParameter((Parameter)StandardParameters.for_, "member");
        boolean server = "server".equals(forParam);
        boolean manager = "manager".equals(forParam);
        boolean archived = req.getParameter((Parameter)StandardParameters.archived, false);
        if (server) {
            groups = DatabaseQuery.getGroupsByNameTitleprefix((Database)db, (int)page, (int)pagesize, (String)nameprefix, (String)titleprefix, (boolean)archived, (boolean)true);
        } else {
            groups = new ArrayList();
            UserDetails userdetails = new UserDetailsManager().get(db, req.getMember().getId(), archived);
            List groupnames = manager ? MemberRule.getManagerGroupnames((UserDetails)userdetails) : MemberRule.getGroupnames((UserDetails)userdetails);
            Collections.sort(groupnames);
            int i = 0;
            int start = pagesize * (page - 1);
            int end = pagesize * page + 1;
            for (String groupname : groupnames) {
                Group group = DatabaseQuery.getGroupByName((Database)db, (String)groupname);
                if (!FindProjects.isGroupVisible(group, nameprefix, titleprefix, archived)) continue;
                if (i >= start && i < end && group != null) {
                    groups.add(group);
                }
                ++i;
            }
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("projects");
        if (groups.size() > pagesize) {
            out.field("limitreached", true);
        }
        int nb = 0;
        out.startCollection("projects", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Group g : groups) {
            if (nb < pagesize) {
                out.writeGroup(g, true, false, false);
            }
            ++nb;
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    private static boolean isGroupVisible(Group group, String nameprefix, String titleprefix, boolean archived) {
        if (group == null) {
            return false;
        }
        String name = group.getName();
        String title = group.getTitle() == null ? "" : group.getTitle().toLowerCase();
        return !"admin".equals(name) && !"public".equals(name) && (!archived || name.startsWith("archive-")) && (nameprefix == null && titleprefix == null || titleprefix == null && name.startsWith(nameprefix.toLowerCase()) || nameprefix == null && title.startsWith(titleprefix.toLowerCase()) || titleprefix != null && nameprefix != null && (name.startsWith(nameprefix.toLowerCase()) || title.startsWith(titleprefix.toLowerCase())));
    }
}

