/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.export;

import com.pageseeder.base.document.URIException;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.export.ExportException;
import com.pageseeder.export.ExportThread;
import com.pageseeder.export.URIToProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.Nullable;

public final class URIExportProcessor {
    private final ExportThread thread;
    private final String context;
    private final List<String> types = new ArrayList<String>();
    private int forwardDepth = 0;
    private int reverseDepth = 0;
    private boolean loadImages = true;
    private boolean loadAlternates = false;
    private String release = null;
    private String compare = null;
    private String publicationid = null;
    private Publication publication = null;
    private final Map<String, URIToProcess> loaded = new ConcurrentHashMap<String, URIToProcess>();
    private Database database = null;
    private Permissions permissions = null;
    private Long memberid = null;
    private UserDetails userdetails = null;
    private Group group = null;
    private final List<String> resolveImageErrors = new ArrayList<String>();

    public URIExportProcessor(ExportThread dad, String ctxt) {
        this.thread = dad;
        this.context = ctxt;
    }

    public void setRelease(String value) {
        this.release = value;
    }

    public void setCompare(String value) {
        this.compare = value;
    }

    public void setPublicationID(String id) {
        this.publicationid = id;
    }

    public void setXRefDepths(int fdepth, int rdepth) {
        this.forwardDepth = fdepth;
        this.reverseDepth = rdepth;
    }

    public void setLoadDetails(boolean images, boolean alternates) {
        this.loadImages = images;
        this.loadAlternates = alternates;
    }

    public void setPermissions(Database db, Group gp, Permissions perm, Long memberid, UserDetails details) {
        this.database = db;
        this.group = gp;
        this.permissions = perm;
        this.memberid = memberid;
        this.userdetails = details;
    }

    public void addTypes(List<String> sometypes) {
        this.types.addAll(sometypes);
    }

    public void process(URI uri, int stopAfter) throws DatabaseException, URIException, ExportException {
        if (this.group == null || this.database == null) {
            throw new IllegalStateException("Database objects must be set first!");
        }
        this.loadURIs(uri, null, 0, true, stopAfter, true);
        this.loadURIs(uri, null, 0, false, stopAfter, true);
    }

    public @Nullable Publication getPublication() {
        return this.publication;
    }

    public Collection<URIToProcess> getURIs() {
        return this.loaded.values();
    }

    public List<String> getResolveImageErrors() {
        return this.resolveImageErrors;
    }

    private boolean hasAccess(URI uri) {
        if (this.userdetails == null || this.memberid == null || this.permissions == null) {
            throw new IllegalStateException("Permissions, username and user details cannot be null.");
        }
        return PermissionManager.check((Long)this.memberid, (UserDetails)this.userdetails, (Database)this.database, (Permissions)this.permissions, (PermissionCheck)new ViewURICheck(uri));
    }

    private List<URI> loadFolders(URI uri) throws QueryFailedException {
        URI dad;
        Object prefix;
        if (URIs.isExternal((URI)uri)) {
            return Collections.emptyList();
        }
        String path = uri.getDecodedPath();
        if (this.loaded.containsKey(path.replaceAll("/[^/]+$", ""))) {
            return Collections.emptyList();
        }
        String groupContext = GlobalSettings.getSitePrefix() + "/" + this.group.getName().replace('-', '/') + "/";
        if (path.startsWith(this.context + "/")) {
            path = path.substring(this.context.length() + 1);
            prefix = this.context + "/";
        } else if (path.startsWith(groupContext)) {
            path = path.substring(groupContext.length());
            prefix = groupContext;
        } else {
            prefix = "";
        }
        ArrayList<URI> folders = new ArrayList<URI>();
        while (path.indexOf(47) != -1 && !this.thread.wasCancelled() && !this.loaded.containsKey(path = path.replaceAll("/[^/]+$", "")) && (dad = DatabaseQuery.getURIBySchemeHostPortPath((Database)this.database, (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)RuleUtils.urlEncodeFilepath((String)((String)prefix + path)))) != null) {
            folders.add(dad);
        }
        return folders;
    }

    private void loadURIs(URI uri, URIToProcess dad, int currentLevel, boolean forward, int stopAfter, boolean fromExport) throws DatabaseException, URIException, ExportException {
        boolean keepGoing;
        boolean processChildren;
        boolean preloading = stopAfter > 0;
        URIToProcess utp = this.getURIToProcess(uri, preloading, fromExport);
        if (this.thread.wasCancelled()) {
            return;
        }
        if (dad != null && dad.isURIAParent(uri.getId())) {
            return;
        }
        utp.setParent(dad);
        if (preloading && this.loaded.size() > stopAfter) {
            return;
        }
        boolean external = URIs.isExternal((URI)uri);
        if (!external && !utp.areFoldersLoaded()) {
            List<URI> folders = this.loadFolders(uri);
            for (URI folder : folders) {
                this.getURIToProcess(folder, preloading, false).foldersLoaded();
                if (!this.thread.wasCancelled()) continue;
                return;
            }
            utp.foldersLoaded();
            if (preloading && this.loaded.size() > stopAfter) {
                return;
            }
        }
        if (this.thread.wasCancelled()) {
            return;
        }
        boolean bl = forward ? currentLevel < this.forwardDepth : (processChildren = currentLevel < this.reverseDepth);
        boolean bl2 = forward ? processChildren || this.loadAlternates || this.loadImages : (keepGoing = processChildren);
        if (keepGoing) {
            boolean processed;
            boolean bl3 = processed = forward ? utp.areForwardXRefsResolved() : utp.areReverseXRefsResolved();
            if (!processed) {
                this.findSubURIsFromXRefs(utp, uri, forward, processChildren);
                if (this.thread.wasCancelled()) {
                    return;
                }
                if (forward) {
                    if (processChildren) {
                        utp.forwardXRefsLoaded();
                    }
                } else {
                    utp.reverseXRefsLoaded();
                }
            }
            Collection<Long> uriids = forward ? utp.getForwardURIsToLoad() : utp.getReverseURIsToLoad();
            for (Long uid : uriids) {
                if (this.thread.wasCancelled()) {
                    return;
                }
                URI toload = DatabaseQuery.getURIById((Database)this.database, (Long)uid);
                int newlevel = currentLevel + (!forward || utp.forwardURIIncreaseDepth(uid) ? 1 : 0);
                if (newlevel > (forward ? this.forwardDepth : this.reverseDepth)) continue;
                this.loadURIs(toload, utp, newlevel, forward, stopAfter, false);
            }
        }
    }

    private URIToProcess getURIToProcess(URI uri, boolean preloading, boolean fromExport) throws DatabaseException, ExportException {
        boolean external = URIs.isExternal((URI)uri);
        String key = (external ? URIRule.getHostURL((URI)uri) : "") + uri.getDecodedPath();
        URIToProcess utp = this.loaded.get(key);
        if (utp == null) {
            if (!external && !this.hasAccess(uri)) {
                throw new ExportException(uri.getId(), uri.getPath());
            }
            utp = new URIToProcess(uri.getId());
            utp.setFromExport(fromExport);
            if ("folder".equals(uri.getType())) {
                utp.imagesResolved();
            }
            this.loaded.put(key, utp);
        }
        if (fromExport) {
            utp.setFromExport(true);
        }
        if (!preloading || this.release != null) {
            this.ensureURIIsLoaded(utp, uri);
        }
        return utp;
    }

    public void ensureURIIsLoaded(URIToProcess utp, URI uri) throws DatabaseException {
        boolean shouldLoad;
        if (utp.isLoaded()) {
            return;
        }
        boolean bl = shouldLoad = this.release != null || this.compare != null;
        if (shouldLoad && !"folder".equals(uri.getType())) {
            Long releaseID;
            if (!Strings.isEmpty((String)this.publicationid) && this.publication == null) {
                this.publication = DatabaseQuery.getPublicationByPublicationIDHost((Database)this.database, (String)this.publicationid, (Host)uri.getHost());
                if (this.publication == null) {
                    this.publicationid = null;
                }
            }
            if ((releaseID = XLinkRule.getValidRelease((Database)this.database, (URI)uri, null, (String)this.release, (Publication)this.publication)) != null && releaseID == 0L) {
                utp.loadOriginalRelease();
            } else if (releaseID != null) {
                utp.setRelease(DatabaseQuery.getXLinkById((Database)this.database, (Long)releaseID));
            }
            if ("current".equals(this.compare)) {
                utp.setCompareID(-1L);
            } else {
                Long compareID = XLinkRule.getValidRelease((Database)this.database, (URI)uri, null, (String)this.compare, (Publication)this.publication);
                if (compareID != null && compareID == 0L) {
                    utp.compareWithOriginalRelease();
                } else if (compareID != null) {
                    utp.setCompareID(DatabaseQuery.getXLinkById((Database)this.database, (Long)compareID).getId());
                }
            }
        }
        utp.setLoaded();
    }

    private void findSubURIsFromXRefs(URIToProcess uo, URI uri, boolean forward, boolean normalXRefs) throws DatabaseException {
        Collection<XLink> xlinks = this.loadXRefs(uo, uri, forward, normalXRefs);
        Long myID = uo.getURIID();
        for (XLink xlink : xlinks) {
            XRef xref = new XRef(xlink);
            URI target = xref.getTargetURI();
            if (target == null || myID.equals(target.getId()) && (!xref.getReverseLink() || myID.equals(xref.getSourceURI().getId()))) continue;
            if (myID.equals(target.getId())) {
                uo.addReverseURI(xref.getSourceURI());
                uo.addReverseXRef(xlink.getId());
            }
            if (myID.equals(xref.getSourceURI().getId())) {
                uo.addForwardURI(target, !xref.isImage() && !xref.isAlternate());
            }
            if (!this.thread.wasCancelled()) continue;
            return;
        }
    }

    private Collection<XLink> loadXRefs(URIToProcess uo, URI uri, boolean forward, boolean normalXRefs) throws DatabaseException {
        if (!forward && uri.getExternal().booleanValue()) {
            return Collections.emptyList();
        }
        Date limitDate = null;
        String status = "Documentation-Old";
        if (uo.getReleaseDate() != null) {
            limitDate = uo.getReleaseDate();
            status = null;
        } else if (uo.hasRelease()) {
            limitDate = uri.getDateCreated();
            status = null;
        }
        Group gp = GroupRule.getEditGroup((Database)this.database, (Group)this.group, (URI)uri);
        ArrayList<String> includeTypes = new ArrayList<String>();
        ArrayList<String> excludeTypes = new ArrayList<String>();
        if (forward) {
            if (normalXRefs) {
                if (this.types != null && !this.types.isEmpty()) {
                    includeTypes.addAll(this.types);
                    if (this.loadImages) {
                        includeTypes.add("image");
                    }
                    if (this.loadAlternates) {
                        includeTypes.add("alternate");
                    }
                }
                if (!this.loadImages) {
                    excludeTypes.add("image");
                }
                if (!this.loadAlternates) {
                    excludeTypes.add("alternate");
                }
            } else {
                if (this.loadImages) {
                    includeTypes.add("image");
                }
                if (this.loadAlternates) {
                    includeTypes.add("alternate");
                }
            }
        } else {
            if (this.types != null && !this.types.isEmpty()) {
                includeTypes.addAll(this.types);
            }
            excludeTypes.add("image");
            excludeTypes.add("alternate");
        }
        return DatabaseQuery.getXRefsByGroupsURIContentRoleStatusCreatedStatusChanged((Database)this.database, Collections.singleton(gp.getName()), (URI)uri, (boolean)forward, includeTypes, excludeTypes, (String)status, (Date)limitDate, (Date)limitDate, (int)-1, (int)-1);
    }
}

