/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.export;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.MultipleCheck;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.export.ExportThread;
import com.pageseeder.export.URIPathPatternFilter;
import com.pageseeder.search.flint.GroupIndex;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.queries.PageSeederQuery;
import com.pageseeder.search.queries.Ranges;
import com.pageseeder.search.utils.SearchUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.ScoreDoc;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(member=true)
public final class Export
implements MultipleCheck,
Generator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Export.class);
    private static final String COMMA = ",";
    private static final int SYNCHRONOUS_MAX_URI = 20;

    public List<PermissionCheck> getPermissionChecks(GeneratorRequest req) {
        boolean showArchived = false;
        UserDetails userDetails = new UserDetailsManager().get(req.getDatabase(), req.getMember().getId(), showArchived);
        ExportDetails details = this.retrieveURIs(req, null, userDetails, true);
        ArrayList<PermissionCheck> checks = new ArrayList<PermissionCheck>();
        checks.add((PermissionCheck)new ViewMemberCheck(req.getMember()));
        if (details == null) {
            checks.add((PermissionCheck)new NoCheck());
        } else if (details.groupURI != null) {
            checks.add((PermissionCheck)new ViewURICheck(details.groupURI));
        } else if (!details.allURIs.isEmpty()) {
            for (URI uri : details.allURIs) {
                checks.add((PermissionCheck)new ViewURICheck(uri));
            }
        }
        if (details != null) {
            checks.add((PermissionCheck)new ViewGroupCheck(details.group));
        }
        return checks;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Database db = req.getDatabase();
        boolean showArchived = false;
        UserDetails userDetails = new UserDetailsManager().get(db, req.getMember().getId(), showArchived);
        ExportDetails details = this.retrieveURIs(req, res, userDetails, false);
        if (details == null) {
            return;
        }
        int independent = this.checkIndependentFolders(db, req, res, details.context);
        if (independent == -1) {
            return;
        }
        ExportThread thread = new ExportThread(req.getMember().getUsername(), details.group, details.context, userDetails);
        String types = req.getParameter((Parameter)StandardParameters.xref_types);
        thread.setXRefFilter(Long.valueOf(req.getParameter((Parameter)StandardParameters.forward_depth, 0L)).intValue(), Long.valueOf(req.getParameter((Parameter)StandardParameters.reverse_depth, 0L)).intValue(), types == null ? null : types.toLowerCase().split(COMMA));
        thread.setRelease(req.getParameter((Parameter)StandardParameters.version, req.getParameter((Parameter)StandardParameters.release)));
        thread.setCompare(req.getParameter((Parameter)StandardParameters.compare));
        thread.setPublication(req.getParameter((Parameter)StandardParameters.publicationid), req.getParameter((Parameter)StandardParameters.process_publication, false), (int)req.getParameter((Parameter)StandardParameters.position, 1L));
        thread.setAllUrls(req.getParameter((Parameter)StandardParameters.allurls, false));
        thread.setMetadataOnly(req.getParameter((Parameter)StandardParameters.metadata_only, false), req.getParameter((Parameter)StandardParameters.binary_metadata_only, req.getParameter((Parameter)StandardParameters.image_metadata_only, false)));
        thread.setInterpublicationXrefs(req.getParameter((Parameter)StandardParameters.interpublication_xrefs, false));
        thread.setIndependent(independent);
        thread.setLoadDetails(req.getParameter((Parameter)StandardParameters.load_images, req.getParameter((Parameter)StandardParameters.resolve_images, true)), req.getParameter((Parameter)StandardParameters.load_alternates, false));
        thread.setFailOnError("true".equals(req.getParameter((Parameter)StandardParameters.fail_on_error, "true")));
        for (URI uri : details.allURIs) {
            thread.addURIToExport(uri.getId());
        }
        if (details.allURIs.size() == 1) {
            thread.setName("Export of " + details.allURIs.iterator().next().getDecodedPath());
        } else {
            thread.setName("Export of " + details.allURIs.size() + " documents");
        }
        ProcessManager manager = ProcessManager.getInstance();
        if (details.allURIs.size() > 20) {
            manager.start((ProcessThread)thread);
            res.setStatus(GeneratorStatus.ACCEPTED);
        } else {
            manager.prepareForStart((ProcessThread)thread, true);
            boolean shouldKeepGoing = thread.processURIs(req.getDatabase(), req.getTransaction(), 20);
            if (shouldKeepGoing) {
                manager.execute((ProcessThread)thread, false);
                res.setStatus(GeneratorStatus.ACCEPTED);
            } else {
                if (thread.hasError()) {
                    res.setStatus(GeneratorStatus.BAD_REQUEST);
                }
                if (thread.hasError() || thread.wasCancelled()) {
                    req.getTransaction().abort();
                }
            }
            manager.clearIfFinished(thread.getThreadID());
        }
        XMLWriter xml = res.getXMLWriter();
        thread.toXML(xml);
    }

    private int checkIndependentFolders(Database db, GeneratorRequest req, GeneratorResponse res, String context) {
        int independent = 0;
        if (req.getParameter((Parameter)StandardParameters.independent, false)) {
            String host = req.getParameter((Parameter)StandardParameters.host, req.getHostName());
            String scheme = Settings.getDocumentScheme();
            int port = Settings.getDocumentPort();
            for (int i = 1; i <= 100; ++i) {
                String path1 = context + "/local" + String.valueOf(i == 1 ? "" : Integer.valueOf(i));
                String path2 = context + "/external" + String.valueOf(i == 1 ? "" : Integer.valueOf(i));
                try {
                    URI uri1 = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)port, (String)RuleUtils.urlEncodeFilepath((String)path1));
                    URI uri2 = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)port, (String)RuleUtils.urlEncodeFilepath((String)path2));
                    if (uri1 != null || uri2 != null) continue;
                    independent = i;
                    break;
                }
                catch (QueryFailedException e) {
                    this.serverError("Failed to load URI with scheme " + scheme + ", host " + host + ", port " + port + " and path " + path1 + " or path " + path2, (Exception)((Object)e), res);
                    return -1;
                }
            }
            if (independent == 0) {
                LOGGER.warn("Failed to create independent folder for export of host: {} , context: {}", (Object)host, (Object)context);
            }
        }
        return independent;
    }

    private ExportDetails retrieveURIs(GeneratorRequest req, GeneratorResponse res, UserDetails userdetails, boolean forPermissions) {
        Database db = req.getDatabase();
        Group group = req.getGroup();
        String context = Export.cleanupContext(req.getParameter((Parameter)StandardParameters.context));
        URI uri = req.getURI();
        if (uri == null) {
            String prefix;
            String host = req.getParameter((Parameter)StandardParameters.host, req.getHostName());
            String scheme = Settings.getDocumentScheme();
            long port = Settings.getDocumentPort();
            Object path = req.getParameter((Parameter)StandardParameters.path);
            String uris = req.getParameter((Parameter)StandardParameters.uris);
            if (path == null && uris == null) {
                if (context == null || group == null) {
                    if (res != null) {
                        res.setError(GeneratorStatus.BAD_REQUEST, "'path', 'uris' or ('context' and 'group') are required if there is no URI specified.");
                    }
                    return null;
                }
                if (forPermissions) {
                    ExportDetails details = new ExportDetails(context);
                    details.setGroup(group);
                    return details;
                }
                return this.filterURIs(scheme, host, (int)port, context, context, group, req, res);
            }
            if (uris != null) {
                if (context == null) {
                    if (res != null) {
                        res.setError(GeneratorStatus.BAD_REQUEST, "'context' is required if 'uris' is specified.");
                    }
                    return null;
                }
                ExportDetails details = new ExportDetails(context);
                URI u = null;
                boolean oneURIBelongsToGroup = false;
                for (String uid : uris.split(COMMA)) {
                    try {
                        u = DatabaseQuery.getURIById((Database)db, (Long)Long.parseLong(uid));
                        if (u == null) {
                            if (res != null) {
                                res.setError(GeneratorStatus.BAD_REQUEST, "Failed to load URI with ID " + uid);
                            }
                            return null;
                        }
                        if (!u.getDecodedPath().startsWith(details.context) && !u.getExternal().booleanValue()) {
                            if (res != null) {
                                res.setError(GeneratorStatus.BAD_REQUEST, "A source URI (" + u.getDecodedPath() + ") is not within the context (" + details.context + ")");
                            }
                            return null;
                        }
                        details.addURI(u);
                        if (oneURIBelongsToGroup || group == null || !URIRule.belongsToGroup((Database)db, (Long)u.getId(), (String)group.getName())) continue;
                        oneURIBelongsToGroup = true;
                    }
                    catch (DatabaseException e) {
                        return this.serverError("Failed to load URI with ID " + uid + " from DB", (Exception)((Object)e), res);
                    }
                    catch (NumberFormatException e) {
                        if (res != null) {
                            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid URI ID " + uid);
                        }
                        return null;
                    }
                }
                if (group == null) {
                    if (u != null) {
                        try {
                            group = URIRule.getGroupForURI((Database)db, (Long)u.getId(), (UserDetails)userdetails);
                        }
                        catch (DatabaseException ex) {
                            return this.serverError("Failed to load groups for URI with ID " + u.getId(), (Exception)((Object)ex), res);
                        }
                    }
                } else if (!oneURIBelongsToGroup) {
                    if (res != null) {
                        res.setError(GeneratorStatus.BAD_REQUEST, "No URIs belong to group (" + group.getName() + ")");
                    }
                    return null;
                }
                details.setGroup(group);
                return details;
            }
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            if (!((String)path).startsWith(prefix = GlobalSettings.getSitePrefix())) {
                path = prefix + (String)path;
            }
            if (((String)path).endsWith("/")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
            try {
                uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)Long.valueOf(port).intValue(), (String)RuleUtils.urlEncodeFilepath((String)path));
            }
            catch (QueryFailedException e) {
                return this.serverError("Failed to load URI with scheme " + scheme + ", host " + host + ", port " + port + " and path " + (String)path, (Exception)((Object)e), res);
            }
            if (uri == null) {
                try {
                    GroupURI guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)Long.valueOf(port).intValue(), (String)((String)path + "/*"));
                    if (guri == null) {
                        if (res != null) {
                            res.setError(GeneratorStatus.NOT_FOUND, "Failed to find URI or Group URI with scheme " + scheme + ", host " + host + ", port " + port + " and path " + (String)path);
                        }
                        return null;
                    }
                    if (context != null && !guri.getPath().startsWith(context)) {
                        if (res != null) {
                            res.setError(GeneratorStatus.BAD_REQUEST, "Source is not within context (" + context + ")");
                        }
                        return null;
                    }
                    if (group == null) {
                        try {
                            group = GroupURIRule.getGroupForGroupURI((Database)db, (Long)guri.getId(), (UserDetails)userdetails);
                        }
                        catch (DatabaseException ex) {
                            return this.serverError("Failed to load groups for Group URI with ID " + guri.getId(), (Exception)((Object)ex), res);
                        }
                    } else if (!GroupURIRule.belongsToGroup((GroupURI)guri, (String)group.getName())) {
                        if (res != null) {
                            res.setError(GeneratorStatus.BAD_REQUEST, "Group URI does not belong to group (" + group.getName() + ")");
                        }
                        return null;
                    }
                    if (forPermissions) {
                        ExportDetails details = new ExportDetails(context != null ? context : GroupURIs.truncatePath((String)guri.getPath()));
                        details.setGroupURI(guri);
                        details.setGroup(group);
                        return details;
                    }
                    return this.filterURIs(guri.getScheme(), guri.getHost().getName(), guri.getPort(), GroupURIs.truncatePath((String)guri.getPath()), GroupURIs.truncatePath((String)guri.getPath()), group, req, res);
                }
                catch (DatabaseException e) {
                    return this.serverError("Failed to load Group URI with scheme " + scheme + ", host " + host + ", port " + port + " and path " + (String)path + "/*", (Exception)((Object)e), res);
                }
            }
        }
        if (context != null && !uri.getDecodedPath().startsWith(context)) {
            if (res != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Source is not within context (" + context + ")");
            }
            return null;
        }
        if (group == null) {
            try {
                group = URIRule.getGroupForURI((Database)db, (Long)uri.getId(), (UserDetails)userdetails);
            }
            catch (DatabaseException e) {
                return this.serverError("Failed to load group for URI " + uri.getId(), (Exception)((Object)e), res);
            }
        }
        try {
            if (!URIRule.belongsToGroup((Database)db, (Long)uri.getId(), (String)group.getName())) {
                if (res != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, "Source does not belong to group (" + group.getName() + ")");
                }
                return null;
            }
        }
        catch (DatabaseException ex) {
            return this.serverError("Failed to check if URI " + uri.getId() + " belongs to Group", (Exception)((Object)ex), res);
        }
        if (!"folder".equals(uri.getType()) && !"unverified".equals(uri.getType()) || forPermissions) {
            ExportDetails details = new ExportDetails(context != null ? context : uri.getDecodedPath().replaceAll("/[^/]+$", ""));
            details.addURI(uri);
            details.setGroup(group);
            return details;
        }
        return this.filterURIs(uri.getScheme(), uri.getHost().getName(), uri.getPort(), uri.getPath(), uri.getDecodedPath(), group, req, res);
    }

    private ExportDetails filterURIs(String scheme, String host, int port, String path, String decoded, Group group, GeneratorRequest req, GeneratorResponse res) {
        String context = Export.cleanupContext(req.getParameter((Parameter)StandardParameters.context));
        Database db = req.getDatabase();
        String with = req.getParameter((Parameter)StandardParameters.with);
        String since = req.getParameter((Parameter)StandardParameters.since);
        String ranges = req.getParameter((Parameter)StandardParameters.ranges);
        String includes = req.getParameter((Parameter)StandardParameters.includes);
        String excludes = req.getParameter((Parameter)StandardParameters.excludes);
        URIPathPatternFilter filter = new URIPathPatternFilter(decoded);
        if (includes != null) {
            filter.addIncludePatterns(includes.split(COMMA));
        }
        if (excludes != null) {
            filter.addExcludePatterns(excludes.split(COMMA));
        }
        if (with == null && since == null && ranges == null) {
            try {
                ExportDetails details = new ExportDetails(context != null ? context : decoded);
                details.setGroup(group);
                for (URI u : DatabaseQuery.getURIsBySchemeHostPortSubpathCol((Database)db, (String)scheme, (String)host, (Integer)port, (String)(path.replaceFirst("/$", "") + "/"))) {
                    if (filter.hasPatterns() && (!filter.isIncluded(u.getDecodedPath()) || filter.isExcluded(u.getDecodedPath()))) continue;
                    details.addURI(u);
                }
                return details;
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to load list of uris", (Throwable)e);
                return this.serverError("Failed to load list of URIs with scheme " + scheme + ", host " + host + ", port " + port + " and path " + decoded, (Exception)((Object)e), res);
            }
        }
        IndexMaster master = IndexMaster.getInstance();
        GroupIndex index = master.getIndex(db, group);
        Catalog catalog = Catalogs.getCatalog((String)index.getCatalog());
        List jobs = master.getIndexJobs(db, group);
        for (String[] job : jobs) {
            if (!job.isBatch()) continue;
            return this.serverError("There is a bulk indexing operation currently running", null, res);
        }
        try {
            SearchResults results;
            PageSeederQuery query;
            PageSeederQuery.Builder builder = new PageSeederQuery.Builder().analyser(index.getAnalyzer()).catalog(catalog).defaultField("pstype").predicate("pstype:document").addStringFilter("psancestor", decoded, BooleanClause.Occur.MUST);
            if (with != null && !with.isEmpty()) {
                for (String withFilter : Strings.split((String)with.trim(), (char)',')) {
                    if (withFilter.isEmpty()) continue;
                    SearchUtils.addFilter((String)withFilter, (Catalog)catalog, (PageSeederQuery.Builder)builder);
                }
            }
            if (since != null) {
                try {
                    builder.addRange(Ranges.createRange((String)("psmodifieddate:[" + ISO8601.DATETIME.format(ISO8601.parseAuto((String)since).getTime()) + ";]"), (Catalog)catalog));
                }
                catch (java.text.ParseException e) {
                    return this.serverError("Failed to parse since date " + since, e, res);
                }
            }
            if (ranges != null && !ranges.isEmpty()) {
                String[] rangesParam;
                for (String range : rangesParam = Strings.split((String)ranges, (char)',')) {
                    if (range.isEmpty()) continue;
                    builder.addRange(Ranges.createRange((String)range, (Catalog)catalog));
                }
            }
            try {
                query = builder.build();
            }
            catch (ParseException ex) {
                return this.serverError("Failed to create filtering query", (Exception)((Object)ex), res);
            }
            ExportDetails details = new ExportDetails(context != null ? context : decoded);
            details.setGroup(group);
            int page = 1;
            int pageSize = 1000;
            int counter = 0;
            while ((results = master.search(db, group, (SearchQuery)query, pageSize, page++)) != null) {
                if (results.getTotalNbOfResults() > 0) {
                    ScoreDoc[] sd = results.getScoreDoc();
                    while (counter < sd.length) {
                        String subpath;
                        Document doc = results.getDocument(sd[counter++].doc);
                        if (filter.hasPatterns() && (!filter.isIncluded(subpath = doc.get("psfolder") + "/" + doc.get("psfilename")) || filter.isExcluded(subpath))) continue;
                        long uriid = Long.parseLong(doc.get("psid"));
                        try {
                            URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                            if (uri != null) {
                                details.addURI(uri);
                                continue;
                            }
                            LOGGER.error("Failed to load a URI from an indexed URI ID {}", (Object)uriid);
                        }
                        catch (DatabaseException e) {
                            return this.serverError("Failed to load indexed URI " + uriid, (Exception)((Object)e), res);
                        }
                    }
                }
                if (counter == results.getTotalNbOfResults()) {
                    results.terminate();
                    break;
                }
                results.terminate();
            }
            return details;
        }
        catch (IndexException e) {
            return this.serverError("Failed to apply filters", (Exception)((Object)e), res);
        }
    }

    private ExportDetails serverError(String message, Exception e, GeneratorResponse res) {
        if (res != null) {
            res.setError(GeneratorStatus.SERVER_ERROR, message + (String)(e == null ? "" : ": " + e.getMessage()));
        } else {
            LOGGER.error(message, (Throwable)e);
        }
        return null;
    }

    private static String cleanupContext(String c) {
        String prefix;
        if (c == null) {
            return null;
        }
        Object cleaned = c;
        if (!((String)cleaned).isEmpty() && ((String)cleaned).charAt(0) != '/') {
            cleaned = "/" + (String)cleaned;
        }
        if (!((String)cleaned).startsWith(prefix = GlobalSettings.getSitePrefix())) {
            cleaned = "/".equals(cleaned) ? prefix : prefix + (String)cleaned;
        }
        if (((String)cleaned).endsWith("/")) {
            cleaned = ((String)cleaned).substring(0, ((String)cleaned).length() - 1);
        }
        return cleaned;
    }

    private static class ExportDetails {
        private final String context;
        private final Collection<URI> allURIs = new ArrayList<URI>();
        private Group group = null;
        private GroupURI groupURI = null;

        ExportDetails(String c) {
            this.context = c;
        }

        public void setGroup(Group gp) {
            this.group = gp;
        }

        void setGroupURI(GroupURI gpu) {
            this.groupURI = gpu;
        }

        void addURI(URI uri) {
            this.allURIs.add(uri);
        }
    }
}

