/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.display;

import com.pageseeder.common.util.MD5;
import com.pageseeder.display.WebImage;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CustomImage
implements WebImage,
Serializable {
    private static final long serialVersionUID = 20201117L;
    private final byte[] _content;
    private final String _mediaType;
    private final String _etag;
    private final long _lastModified;

    public CustomImage(byte[] content, String mediaType, long lastModified) {
        this._content = content;
        this._mediaType = mediaType;
        this._lastModified = lastModified;
        this._etag = "\"" + MD5.hash((byte[])content).substring(0, 8) + "\"";
    }

    @Override
    public String getEtag() {
        return this._etag;
    }

    @Override
    public long getLastModified() {
        return this._lastModified;
    }

    @Override
    public void write(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String etag = req.getHeader("If-None-Match");
        if (etag != null) {
            if (etag.equals(this._etag)) {
                res.setStatus(304);
                this.writeCommonHeaders(res);
                return;
            }
        } else {
            try {
                long since = req.getDateHeader("If-Modified-Since");
                if (since > 0L && since == this.getLastModified()) {
                    res.setStatus(304);
                    this.writeCommonHeaders(res);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.write(res);
    }

    @Override
    public void write(HttpServletResponse res) throws IOException {
        res.setContentType(this._mediaType);
        res.setContentLength(this._content.length);
        res.setDateHeader("Last-Modified", this.getLastModified());
        this.writeCommonHeaders(res);
        ServletOutputStream out = res.getOutputStream();
        out.write(this._content);
        out.flush();
    }

    private void writeCommonHeaders(HttpServletResponse res) {
        res.setDateHeader("Date", System.currentTimeMillis());
        res.setHeader("ETag", this._etag);
        res.setHeader("Cache-Control", "no-cache");
    }
}

