/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer.config;

import java.io.File;

public enum ResourceType {
    XML("text/xml", new String[]{"xml"}),
    XSLT("text/xml", new String[]{"xsl", "xslt"}),
    CSS("text/css", new String[]{"css"}),
    JAVASCRIPT("application/javascript", new String[]{"js"}),
    JSON("application/json", new String[]{"json"}),
    PROPERTIES("text/plain", new String[]{"prp", "properties"}),
    UNKNOWN("text/plain", new String[0]);

    private final String _mime;
    private final String[] _extensions;

    private ResourceType(String mime, String[] extensions) {
        this._mime = mime;
        this._extensions = extensions;
    }

    public String getMimeType() {
        return this._mime;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static ResourceType getType(File f) {
        String name = f.getName();
        int dot = name.lastIndexOf(46) + 1;
        if (dot <= 0) {
            return UNKNOWN;
        }
        String ext = name.substring(dot);
        for (ResourceType type : ResourceType.values()) {
            for (String x : type._extensions) {
                if (!x.equalsIgnoreCase(ext)) continue;
                return type;
            }
        }
        return UNKNOWN;
    }
}

