/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer.config;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.developer.config.ResourceType;
import java.io.File;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class Resource
implements XMLWritable,
UniversallyPrintable {
    private static final String[] LOCATION_PREFIXES = new String[]{File.separatorChar + "WEB-INF", File.separatorChar + "weborganic", File.separatorChar + "woconfig"};
    private final File _file;
    private final boolean _editable;
    private final ResourceType type;

    public Resource(File file, boolean editable) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException("Cannot create a new resource with a null file!");
        }
        this._file = file;
        this._editable = editable;
        this.type = ResourceType.getType(file);
    }

    public File getFile() {
        return this._file;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public ResourceType getType() {
        return this.type;
    }

    public void toXML(XMLWriter xml) {
        this.print((OutputPrinter)new XMLOutputPrinter(xml));
    }

    public void print(OutputPrinter out) {
        out.startObject("resource");
        out.field("exists", this._file.exists());
        out.field("editable", this._editable);
        String location = Resource.toLocation(this._file);
        if (location != null) {
            out.field("location", location, OutputPrinter.FieldOption.XML_ELEMENT);
        }
        out.field("file", this._file.getName(), OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("type", this.type.toString(), OutputPrinter.FieldOption.XML_ELEMENT);
        out.endObject();
    }

    static String toLocation(File f) {
        String path = f.getParentFile().getPath();
        for (String prefix : LOCATION_PREFIXES) {
            int x = path.indexOf(prefix);
            if (x < 0) continue;
            return path.substring(x).replace("\\", "/");
        }
        return null;
    }
}

