/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer.config;

import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.developer.config.Bundle;
import com.pageseeder.developer.config.BundleBase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PublicationConfigBundle
extends BundleBase
implements Bundle {
    private static final UniversalPrinter.FileFields ROLES = new UniversalPrinter.FileFields(){

        public void print(OutputPrinter out, File f, String location) {
            out.field("role", "Publication Config");
            boolean isDefaultTemplate = location.startsWith(TemplateFiles.Zone.TEMPLATE.folder(Template.DEFAULT));
            boolean isDefaultWeb = location.startsWith(TemplateFiles.Zone.WEB.folder(Template.DEFAULT));
            out.field("editable", Boolean.toString(!isDefaultTemplate && !isDefaultWeb));
            if (isDefaultTemplate || isDefaultWeb) {
                out.field("definedby", "default");
            } else if (location.startsWith(TemplateFiles.Zone.TEMPLATE.folder())) {
                out.field("definedby", location.substring(TemplateFiles.Zone.TEMPLATE.folder().length() + 1).split("/")[0]);
            }
        }
    };

    protected PublicationConfigBundle(String name) {
        super(name);
    }

    @Override
    public void load(Template template, File webapp) {
        TemplateFiles resources = new TemplateFiles(template, webapp);
        this.add(resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/publication/" + this.name() + "/publication-config.xml"));
        this.add(resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/publication/" + this.name() + "/word-export-config.xml"));
        this.add(resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/publication/" + this.name() + "/word-export-template.docx"));
        this.add(resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/publication/" + this.name() + "/pdf-export-config.xml"));
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("bundle");
        xml.attribute("name", this.name());
        xml.attribute("type", "publication");
        for (File f : this.files()) {
            UniversalPrinter p = UniversalPrinter.newWriter((OutputType)OutputType.XML);
            try {
                p.writeFile(f, 0, false, ROLES);
                xml.writeXML(p.toString());
            }
            finally {
                if (p == null) continue;
                p.close();
            }
        }
        xml.closeElement();
    }

    public static PublicationConfigBundle forLocation(String location) {
        Template kit = TemplateFactory.forLocation((String)location);
        if (kit == null) {
            return null;
        }
        String prefix = TemplateFiles.Zone.TEMPLATE.folder(kit);
        if (location.startsWith(prefix)) {
            return PublicationConfigBundle.forTemplateLocation(location.substring(prefix.length()));
        }
        return null;
    }

    public static List<String> list(Template template, File webapp) {
        TemplateFiles resources = new TemplateFiles(template, webapp);
        ArrayList<String> names = new ArrayList<String>();
        File documents = resources.get((TemplateZone)TemplateFiles.Zone.TEMPLATE, "/publication/");
        if (documents.exists() && documents.listFiles() != null) {
            for (File f : documents.listFiles()) {
                String name = f.getName();
                if (!f.isDirectory() || f.isHidden() || !Publications.isValidPublicationType((String)name)) continue;
                names.add(name);
            }
        }
        return names;
    }

    private static PublicationConfigBundle forTemplateLocation(String location) {
        Pattern pattern = Pattern.compile("/publication/([a-zA-Z0-9_\\-]+)/.*");
        Matcher m = pattern.matcher(location);
        if (m.matches()) {
            return new PublicationConfigBundle(m.group(1));
        }
        return null;
    }
}

