/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.io.TemplateHistory;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.developer.DevUtils;
import com.pageseeder.developer.DeveloperZone;
import com.pageseeder.developer.config.Resource;
import com.pageseeder.group.GroupErrorID;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UploadResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = -6517647547309137220L;
    private static final UniversalPrinter.FileFields UPLOADED_ATTRIBUTE = (out, f, location) -> {
        if (f.exists()) {
            out.field("status", "uploaded");
        }
    };
    private static final String FILENAME_HEADER = "X-File-Name";
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadResourceServlet.class);
    private File webapp;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config != null) {
            ServletContext context = config.getServletContext();
            this.webapp = new File(context.getRealPath("/"));
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Database db;
        long start = System.currentTimeMillis();
        Long groupId = null;
        String groupName = null;
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if ((db = WebRequest.getDatabase((HttpServletResponse)res)) == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Permissions perm = new Permissions();
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new DevelopCheck())) {
                tr.abort();
                return;
            }
            if (!CSRF.validateAntiCSRFToken((HttpServletRequest)req)) {
                res.sendError(419, "Missing correct CSRF token");
                tr.abort();
                return;
            }
            boolean ok = UploadResourceServlet.checkPutPreconditions(req, res);
            if (!ok) {
                return;
            }
            File destination = null;
            Template kit = null;
            if (req.getParameter("group") != null) {
                Group group = GroupRule.getGroup((Database)db, (String)req.getParameter("group"));
                if (group == null) {
                    WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)400, (ErrorID)GroupErrorID.INVALID_GROUP_PARAMETER);
                    tr.abort();
                    return;
                }
                groupId = group.getId();
                groupName = group.getName();
                String template = GroupRule.getTemplate((Group)group);
                if (template == null) {
                    res.sendError(400, "Group cannot be customised (owner is null)");
                    tr.abort();
                    return;
                }
                kit = new Template(template);
                File dropbox = Files.descendantFile((File)this.webapp, (String)DeveloperZone.DROPBOX.folder(kit));
                dropbox.mkdirs();
                destination = Files.descendantFile((File)dropbox, (String)FilenameUtils.getName((String)req.getHeader(FILENAME_HEADER)));
            } else {
                String location = req.getParameter("location");
                kit = TemplateFactory.forLocation((String)(location + "/"));
                LOGGER.debug("Using location: {}", (Object)location);
                boolean allow = DevUtils.allowEditing(db, location, null);
                if (!allow) {
                    res.sendError(403, "Cannot upload at specified location");
                    tr.abort();
                    return;
                }
                destination = this.toFile(location, FilenameUtils.getName((String)req.getHeader(FILENAME_HEADER)));
                if (destination == null) {
                    res.sendError(403, "Cannot upload at specified location");
                    tr.abort();
                    return;
                }
            }
            if (destination.exists() && !"true".equals(req.getParameter("overwrite"))) {
                res.sendError(409, "Destination file already exist and overwrite is set to false");
                tr.abort();
                return;
            }
            destination.getParentFile().mkdirs();
            if (!destination.getParentFile().exists()) {
                res.sendError(500, "Failed to create destination folder");
                return;
            }
            LOGGER.debug("destination: {}", (Object)destination);
            try (ServletInputStream in = req.getInputStream();
                 FileOutputStream out = FileUtils.openOutputStream((File)destination);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            TemplateHistory history = new TemplateHistory(kit, this.webapp);
            history.backup("/" + Files.path((File)this.webapp, (File)destination));
            this.printXML(res, destination);
            tr.commit();
            WebUtilities.logAccess((HttpServletRequest)req, (int)200, (String)"upload-resource", (long)start, (AccessEvent.Permission)AccessEvent.Permission.ADMINISTRATOR, (Long)groupId, (String)groupName);
        }
        catch (StartTransactionException ex) {
            WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (Throwable)ex, (ServletConfig)this.getServletConfig());
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"upload-resource", (long)start, (AccessEvent.Permission)AccessEvent.Permission.ADMINISTRATOR, groupId, groupName);
        }
        catch (DatabaseException ex) {
            tr.abort();
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"upload-resource", (long)start, (AccessEvent.Permission)AccessEvent.Permission.ADMINISTRATOR, groupId, groupName);
            throw new ServletException((Throwable)ex);
        }
        finally {
            db.close();
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Database db;
        long start = System.currentTimeMillis();
        Long groupId = null;
        String groupName = null;
        AccessEvent.Permission accessPermission = AccessEvent.Permission.ADMINISTRATOR;
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if ((db = WebRequest.getDatabase((HttpServletResponse)res)) == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Group project = null;
            Permissions perm = new Permissions();
            if (req.getParameter("group") != null) {
                Group group = GroupRule.getGroup((Database)db, (String)req.getParameter("group"));
                if (group == null) {
                    WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)400, (ErrorID)GroupErrorID.INVALID_GROUP_PARAMETER);
                    tr.abort();
                    return;
                }
                groupId = group.getId();
                groupName = group.getName();
                accessPermission = AccessEvent.Permission.PROJECT_MANAGER;
                Group group2 = project = GroupRule.isProject((Group)group) ? group : GroupRule.getTemplateProject((Database)db, (Group)group);
                if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new ConfigureProjectCheck(group))) {
                    tr.abort();
                    return;
                }
            } else if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new DevelopCheck())) {
                tr.abort();
                return;
            }
            if (!CSRF.validateAntiCSRFToken((HttpServletRequest)req)) {
                res.sendError(419, "Missing correct CSRF token");
                tr.abort();
                return;
            }
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
            ArrayList<UploadedResource> uploaded = new ArrayList<UploadedResource>();
            if (isMultipart) {
                uploaded.addAll(this.getFromMultipart(db, req, res, project));
            } else if (req.getHeader(FILENAME_HEADER) != null) {
                uploaded.addAll(this.getFromRequestContent(db, req, res, project));
            }
            UploadResourceServlet.printXML(res, uploaded);
            tr.commit();
            WebUtilities.logAccess((HttpServletRequest)req, (int)200, (String)"upload-resource", (long)start, (AccessEvent.Permission)accessPermission, (Long)groupId, (String)groupName);
        }
        catch (StartTransactionException ex) {
            WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (Throwable)ex, (ServletConfig)this.getServletConfig());
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"upload-resource", (long)start, (AccessEvent.Permission)accessPermission, groupId, groupName);
        }
        catch (FileUploadBase.SizeLimitExceededException ex) {
            tr.abort();
            res.sendError(413, "Content length exceeds " + GlobalSettings.getLong((String)"maxUploadSize", (long)100000000L));
            try (ServletInputStream in = req.getInputStream();){
                in.transferTo(OutputStream.nullOutputStream());
            }
            WebUtilities.logAccess((HttpServletRequest)req, (int)413, (String)"upload-resource", (long)start, (AccessEvent.Permission)accessPermission, (Long)groupId, (String)groupName);
        }
        catch (Exception ex) {
            tr.abort();
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"upload-resource", (long)start, (AccessEvent.Permission)accessPermission, groupId, groupName);
            throw new ServletException((Throwable)ex);
        }
        finally {
            db.close();
        }
    }

    public String getServletInfo() {
        return "Returns/updates the contents of a resource.";
    }

    public void destroy() {
        this.webapp = null;
    }

    private Collection<UploadedResource> getFromMultipart(Database db, HttpServletRequest req, HttpServletResponse res, Group project) throws QueryFailedException, IOException, FileUploadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        HashMap<Integer, UploadedResource> uploaded = new HashMap<Integer, UploadedResource>();
        List<FileItem> items = UploadResourceServlet.parseRequest((FileItemFactory)factory, req);
        String location = "/";
        boolean overwrite = false;
        for (FileItem item : items) {
            String name = item.getFieldName();
            if ("location".equals(name)) {
                location = item.getString();
                continue;
            }
            if (!"overwrite".equals(name)) continue;
            overwrite = "true".equals(item.getString());
        }
        boolean allow = DevUtils.allowEditing(db, location, project);
        if (!allow) {
            res.setStatus(403);
        } else {
            for (FileItem item : items) {
                LOGGER.debug("parsing: {}", (Object)item.getFieldName());
                String fieldName = item.getFieldName();
                int dash = fieldName.lastIndexOf(45);
                if (dash < 0 || !fieldName.substring(dash + 1).matches("\\d+")) continue;
                Integer i = Integer.parseInt(fieldName.substring(dash + 1));
                UploadedResource ur = (UploadedResource)uploaded.get(i);
                if (ur == null) {
                    ur = new UploadedResource();
                    ur.setOverwrite(overwrite);
                    uploaded.put(i, ur);
                }
                if (item.isFormField()) continue;
                LOGGER.debug("found: {}({}) [{}]", new Object[]{item.getName(), FilenameUtils.getName((String)item.getName()), item.getContentType()});
                String filename = FilenameUtils.getName((String)item.getName());
                if (project != null && !this.managerCanEdit(filename)) {
                    res.setStatus(403);
                    return Collections.emptyList();
                }
                File target = this.toFile(location, filename);
                if (target.exists()) {
                    if (!ur.overwrite) {
                        res.sendError(409, "Destination file already exist and overwrite is set to false");
                        return Collections.emptyList();
                    }
                    if (!target.delete()) {
                        throw new IOException("Unable to delete existing file.");
                    }
                }
                target.getParentFile().mkdirs();
                if (!target.getParentFile().exists()) {
                    throw new IOException("Failed to create destination folder");
                }
                Resource rc = new Resource(target, true);
                ur.setResource(rc);
                try {
                    item.write(target);
                }
                catch (Exception ex) {
                    throw new IOException("Unable to write uploaded resource", ex);
                }
                TemplateHistory history = new TemplateHistory(TemplateFactory.forLocation((String)(location + "/")), this.webapp);
                history.backup("/" + Files.path((File)this.webapp, (File)target));
            }
        }
        return uploaded.values();
    }

    private Collection<UploadedResource> getFromRequestContent(Database db, HttpServletRequest req, HttpServletResponse res, Group project) throws QueryFailedException, IOException {
        String location = req.getParameter("location");
        LOGGER.debug("location: {}", (Object)location);
        boolean allow = DevUtils.allowEditing(db, location, project);
        if (allow) {
            String name = req.getHeader(FILENAME_HEADER);
            LOGGER.debug("found: {}({})", (Object)name, (Object)FilenameUtils.getName((String)name));
            if (project != null && !this.managerCanEdit(name)) {
                res.setStatus(403);
                return Collections.emptyList();
            }
            File target = this.toFile(location, name);
            boolean overwrite = "true".equals(req.getParameter("overwrite"));
            if (target.exists() && !overwrite) {
                res.sendError(409, "Destination file already exist and overwrite is set to false");
                return Collections.emptyList();
            }
            target.getParentFile().mkdirs();
            if (!target.getParentFile().exists()) {
                throw new IOException("Failed to create destination folder");
            }
            Resource rc = new Resource(target, true);
            UploadedResource ur = new UploadedResource(rc);
            try (FileOutputStream out = FileUtils.openOutputStream((File)target);){
                IOUtils.copy((InputStream)req.getInputStream(), (OutputStream)out);
            }
            catch (IOException ex) {
                throw new IOException("Unable to write uploaded resource", ex);
            }
            TemplateHistory history = new TemplateHistory(TemplateFactory.forLocation((String)(location + "/")), this.webapp);
            history.backup("/" + Files.path((File)this.webapp, (File)target));
            return Collections.singletonList(ur);
        }
        res.setStatus(403);
        return Collections.emptyList();
    }

    private static boolean checkPutPreconditions(HttpServletRequest req, HttpServletResponse res) throws IOException {
        long maxLength;
        if (req.getHeader("Content-Length") == null) {
            res.sendError(411, "HTTP header 'Content-Length' is required");
            return false;
        }
        long length = HttpRequests.getLongHeader((HttpServletRequest)req, (String)"Content-Length");
        if (length > (maxLength = GlobalSettings.getLong((String)"maxUploadSize", (long)100000000L))) {
            res.sendError(413, "Content length exceeds 10000000");
            HttpRequests.consumeInputStream((HttpServletRequest)req);
            return false;
        }
        String name = req.getHeader(FILENAME_HEADER);
        if (req.getHeader(FILENAME_HEADER) == null) {
            res.sendError(412, "HTTP header 'X-File-Name' is required");
            return false;
        }
        if (!name.matches("[^./][\\x00-\\x7F&&[^/\\\\]]+")) {
            res.sendError(412, "HTTP header 'X-File-Name' is invalid");
            return false;
        }
        if (req.getParameter("location") == null && req.getParameter("group") == null) {
            res.sendError(400, "HTTP parameter 'location' or 'group'  is required");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printXML(HttpServletResponse res, Collection<UploadedResource> uploaded) throws IOException {
        res.setContentType("application/xml");
        PrintWriter out = res.getWriter();
        try {
            XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.Yes);
            xml.openElement("upload-resource-servlet", true);
            for (UploadedResource ur : uploaded) {
                ur.toXML((XMLWriter)xml);
            }
            xml.closeElement();
            xml.flush();
            out.print(xml);
        }
        finally {
            out.flush();
        }
    }

    private void printXML(HttpServletResponse res, File file) throws IOException {
        res.setContentType("application/xml");
        try (PrintWriter out = res.getWriter();
             UniversalPrinter p = UniversalPrinter.newWriter((OutputType)OutputType.XML);){
            p.writeFile(file, new File(Settings.getContextPath()), 0, true, UPLOADED_ATTRIBUTE);
            p.flush();
            out.print(p);
        }
    }

    private File toFile(String location, String name) throws IOException {
        if (location == null || location.contains("..")) {
            throw new IOException("Invalid location");
        }
        if (name == null || !name.matches("[^./][\\x00-\\x7F&&[^/\\\\]]+")) {
            throw new IOException("Invalid filename");
        }
        return Files.descendantFile((File)this.webapp, (String)(location + File.separator + name));
    }

    private static List<FileItem> parseRequest(FileItemFactory factory, HttpServletRequest req) throws FileUploadException {
        ServletFileUpload upload = new ServletFileUpload(factory);
        upload.setSizeMax(GlobalSettings.getLong((String)"maxUploadSize", (long)100000000L));
        upload.setFileCountMax(10000L);
        return upload.parseRequest(req);
    }

    private boolean managerCanEdit(String filename) {
        return "word-export-template.docx".equals(filename);
    }

    private static final class UploadedResource
    implements XMLWritable {
        private Resource _resource;
        private boolean overwrite;

        public UploadedResource() {
        }

        public UploadedResource(Resource resource) {
            this._resource = resource;
        }

        public void toXML(XMLWriter xml) throws IOException {
            xml.openElement("uploaded-resource");
            xml.attribute("overwrite", this.overwrite ? "true" : "false");
            this._resource.toXML(xml);
            xml.closeElement();
        }

        public void setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public void setResource(Resource resource) {
            this._resource = resource;
        }
    }
}

