/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.io.CharsetDetector;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.ResourceCompressor;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.developer.DevUtils;
import com.pageseeder.group.GroupErrorID;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 4005269787730968910L;
    private static final int WRITE_BUFFER = 2048;
    private File webapp = null;

    public void destroy() {
        this.webapp = null;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config != null) {
            ServletContext context = config.getServletContext();
            this.webapp = new File(context.getRealPath("/"));
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.getResource(request, response, true);
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.getResource(request, response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getResource(HttpServletRequest req, HttpServletResponse res, boolean content) throws IOException, ServletException {
        long contentLength;
        File file;
        Template kit;
        AccessEvent.Permission accessPermission;
        long start = System.currentTimeMillis();
        Long groupId = null;
        String groupName = null;
        boolean includeContent = content;
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        WebRequest wr = new WebRequest(req, res);
        boolean publisherSessionFile = false;
        boolean configFile = false;
        String group = req.getParameter("group");
        Object location = wr.getParameter("location", false);
        AccessEvent.Permission permission = accessPermission = group != null ? AccessEvent.Permission.PROJECT_MANAGER : AccessEvent.Permission.ADMINISTRATOR;
        if (location == null) {
            String servlet = req.getServletPath();
            if ("/publish/session".equals(servlet)) {
                location = "/WEB-INF/state" + servlet + req.getPathInfo();
                publisherSessionFile = true;
                accessPermission = AccessEvent.Permission.MEMBER;
            } else {
                location = wr.getParameter("location", true);
            }
        } else {
            boolean bl = configFile = group == null && (((String)location).startsWith("/WEB-INF/sysconfig/") || ((String)location).startsWith("/WEB-INF/config/"));
        }
        if (wr.hasError()) {
            return;
        }
        if (location != null && (((String)location).contains("../") || ((String)location).contains("..\\"))) {
            res.sendError(400, "location is invalid");
            WebUtilities.logAccess((HttpServletRequest)req, (int)400, (String)"resource", (long)start, (AccessEvent.Permission)accessPermission);
            return;
        }
        Template template = kit = publisherSessionFile ? null : TemplateFactory.forLocation((String)location);
        if (!publisherSessionFile && !configFile && kit == null) {
            res.sendError(403, "location is invalid");
            WebUtilities.logAccess((HttpServletRequest)req, (int)403, (String)"resource", (long)start, (AccessEvent.Permission)accessPermission);
            return;
        }
        if (!publisherSessionFile) {
            boolean allowed = false;
            Database db = WebRequest.getDatabase((HttpServletResponse)res);
            if (db == null) {
                return;
            }
            Transaction tr = null;
            try {
                List<Group> projects;
                tr = new Transaction(db);
                tr.begin();
                Permissions perm = new Permissions();
                if (group != null) {
                    Group groupObject = GroupRule.getGroup((Database)db, (String)group);
                    if (groupObject == null) {
                        WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)400, (ErrorID)GroupErrorID.INVALID_GROUP_PARAMETER);
                        tr.abort();
                        return;
                    }
                    groupId = groupObject.getId();
                    groupName = groupObject.getName();
                    projects = Collections.singletonList(GroupRule.isProject((Group)groupObject) ? groupObject : GroupRule.getTemplateProject((Database)db, (Group)groupObject));
                    if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new ConfigureProjectCheck(groupObject))) {
                        tr.abort();
                        return;
                    }
                } else {
                    if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new DevelopCheck())) {
                        tr.abort();
                        return;
                    }
                    projects = configFile ? null : DatabaseQuery.getAllProjects((Database)db);
                }
                allowed = configFile || DevUtils.allowViewing((String)location, projects);
                tr.commit();
            }
            catch (StartTransactionException ex) {
                WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (Throwable)ex, (ServletConfig)this.getServletConfig());
                WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"resource", (long)start, (AccessEvent.Permission)accessPermission);
                return;
            }
            catch (Exception ex) {
                tr.abort();
                WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"resource", (long)start, (AccessEvent.Permission)accessPermission);
                throw new ServletException((Throwable)ex);
            }
            finally {
                db.close();
                db = null;
            }
            if (!allowed) {
                res.sendError(403, "location is invalid");
                return;
            }
        }
        if (!(file = Files.descendantFile((File)this.webapp, (String)location)).exists()) {
            res.sendError(404, "location is invalid");
            WebUtilities.logAccess((HttpServletRequest)req, (int)404, (String)"resource", (long)start, (AccessEvent.Permission)accessPermission);
            return;
        }
        String media = Medias.getMediaType((File)file);
        if (media != null) {
            res.setContentType(media);
        }
        if (req.getHeader("Range") != null) {
            res.setHeader("Accept-Ranges", "none");
        }
        if ((contentLength = file.length()) == 0L) {
            includeContent = false;
        }
        HttpRequests.setContentLength((HttpServletResponse)res, (long)contentLength);
        res.setDateHeader("Last-Modified", file.lastModified());
        res.setHeader("Cache-Control", "no-cache");
        if (includeContent) {
            ServletOutputStream out;
            if ("true".equals(wr.getParameter("download"))) {
                res.setHeader("Content-Disposition", HttpRequests.toSafeHeader((String)("attachment; filename=" + file.getName())));
            }
            res.setCharacterEncoding("utf-8");
            res.setBufferSize(2048);
            if (HttpRequests.isCompressible((String)media)) {
                res.setHeader("Vary", "Accept-Encoding");
                if (HttpRequests.acceptsGZipCompression((HttpServletRequest)req)) {
                    Object c;
                    byte[] compressed = null;
                    if (Medias.isText((String)media)) {
                        c = CharsetDetector.decode((File)file);
                        compressed = ResourceCompressor.compress((byte[])((CharBuffer)c).toString().getBytes(StandardCharsets.UTF_8));
                    } else {
                        c = FileUtils.readFileToByteArray((File)file);
                        compressed = ResourceCompressor.compress((byte[])c);
                    }
                    res.setIntHeader("Content-Length", compressed.length);
                    res.setHeader("Content-Encoding", "gzip");
                    out = res.getOutputStream();
                    try {
                        out.write(compressed);
                        out.flush();
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                    return;
                }
            }
            if (Medias.isText((String)media)) {
                CharBuffer c = CharsetDetector.decode((File)file);
                try (PrintWriter writer = res.getWriter();){
                    writer.print(c.toString());
                    writer.flush();
                }
            }
            BufferedInputStream in = null;
            try {
                out = res.getOutputStream();
                try {
                    in = new BufferedInputStream(FileUtils.openInputStream((File)file));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.flush();
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        if (req.getAttribute("com.pageseeder.layout") != Boolean.TRUE) {
            WebUtilities.logAccess((HttpServletRequest)req, (int)200, (String)"resource", (long)start, (AccessEvent.Permission)accessPermission);
        }
    }
}

