/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateHistory;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.model.Group;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true, parameters={"location", "to"})
public final class MoveProjectFile
implements Generator,
SingleCheck {
    private volatile File webapp = null;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        String owner = GroupRule.getTemplate((Group)group);
        Template kit = TemplateFactory.forLocation((String)req.getParameter((Parameter)StandardParameters.location));
        if (kit == null || kit.isDefault() || !kit.name().equals(owner)) {
            return new ForbiddenCheck();
        }
        Template template2 = TemplateFactory.forLocation((String)(req.getParameter((Parameter)StandardParameters.to) + "/"));
        if (template2 == null || !template2.name().equals(owner)) {
            return new ForbiddenCheck();
        }
        return new DevelopCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        if (this.webapp == null) {
            this.webapp = new File(Settings.getContextPath());
        }
        XMLWriter xml = res.getXMLWriter();
        String owner = GroupRule.getTemplate((Group)group);
        if (owner != null) {
            String location = req.getParameter((Parameter)StandardParameters.location);
            Template template = TemplateFactory.forLocation((String)location);
            TemplateFiles kr = new TemplateFiles(template);
            File from = new File(this.webapp, location);
            File to = new File(this.webapp, req.getParameter((Parameter)StandardParameters.to));
            boolean isTemplate = Files.isDescendantOf((File)kr.getTemplateDirectory(), (File)from);
            boolean isWebFile = Files.isDescendantOf((File)kr.getWebDirectory(), (File)from);
            xml.openElement("file");
            if (template.isDefault() || !isTemplate && !isWebFile) {
                xml.attribute("status", "forbidden");
            } else if (from.exists()) {
                if (from.isDirectory()) {
                    xml.attribute("type", "folder");
                    if (to.exists()) {
                        if (to.isFile()) {
                            res.setError(GeneratorStatus.BAD_REQUEST, "Cannot move a directory to a file");
                        } else if (to.isDirectory() && !"yes".equals(req.getParameter((Parameter)StandardParameters.overwrite))) {
                            res.setError(GeneratorStatus.BAD_REQUEST, "Target directory already exists.");
                        }
                    }
                } else {
                    xml.attribute("type", "file");
                    if (to.exists()) {
                        if (to.isDirectory()) {
                            if ((to = new File(to, from.getName())).exists() && to.isDirectory()) {
                                res.setError(GeneratorStatus.BAD_REQUEST, "Target file is a directory.");
                            }
                        } else if (!"yes".equals(req.getParameter((Parameter)StandardParameters.overwrite))) {
                            res.setError(GeneratorStatus.BAD_REQUEST, "Target file already exists.");
                        }
                    }
                }
                if (res.getStatus() != GeneratorStatus.BAD_REQUEST) {
                    boolean ok;
                    File dir = to.getParentFile();
                    if (!dir.exists()) {
                        FileUtils.forceMkdir((File)dir);
                    }
                    if (ok = from.renameTo(to)) {
                        xml.attribute("name", to.getName());
                        xml.attribute("path", "/" + Files.path((File)this.webapp, (File)to));
                        xml.attribute("status", "moved");
                        xml.attribute("from", "/" + Files.path((File)this.webapp, (File)from));
                        xml.attribute("modified", ISO8601.DATETIME.format(to.lastModified()));
                        if (to.isFile()) {
                            String type = Medias.getMediaType((File)to);
                            if (type != null) {
                                xml.attribute("mediatype", type);
                            }
                            xml.attribute("text", Boolean.toString(Medias.isText((String)type)));
                            xml.attribute("length", Long.toString(to.length()));
                            TemplateHistory history = new TemplateHistory(kr);
                            history.backup("/" + Files.path((File)this.webapp, (File)to));
                        }
                    } else {
                        xml.attribute("status", "move-failed");
                        res.setStatus(GeneratorStatus.SERVER_ERROR);
                    }
                }
            } else {
                xml.attribute("status", "not-found");
                res.setStatus(GeneratorStatus.NOT_FOUND);
            }
            xml.closeElement();
        } else {
            xml.emptyElement("no-style-owner");
        }
        xml.flush();
    }
}

