/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import java.io.FileFilter;
import java.util.Collection;

final class DevUtils {
    protected static final FileFilter READABLE_AND_VISIBLE = file -> file.canRead() && !file.isHidden() && file.getName().indexOf(46) != 0;

    private DevUtils() {
    }

    public static boolean allowEditing(Database db, String location, Group project) throws QueryFailedException {
        Group p;
        Template kit = TemplateFactory.forLocation((String)(location + "/"));
        if (kit == null || kit.isDefault()) {
            return false;
        }
        return project != null ? project.getName().equals(kit.name()) : (p = DatabaseQuery.getGroupByName((Database)db, (String)kit.name())) != null && GroupRule.isProject((Group)p);
    }

    public static boolean allowViewing(String location, Collection<Group> projects) {
        Template kit = TemplateFactory.forLocation((String)location);
        if (kit == null) {
            return false;
        }
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        if (kit.isDefault() || kit.name().equals(globalTemplate)) {
            return true;
        }
        for (Group p : projects) {
            if (!p.getName().equals(kit.name())) continue;
            return true;
        }
        return false;
    }
}

