/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateHistory;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.model.Group;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true, parameters={"location"})
public final class CreateProjectFile
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        String owner = GroupRule.getTemplate((Group)group);
        Template kit = TemplateFactory.forLocation((String)req.getParameter((Parameter)StandardParameters.location));
        if (kit == null || kit.isDefault() || !kit.name().equals(owner)) {
            return new ForbiddenCheck();
        }
        return new DevelopCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        XMLWriter xml = res.getXMLWriter();
        String owner = GroupRule.getTemplate((Group)group);
        if (owner != null) {
            String location = req.getParameter((Parameter)StandardParameters.location);
            Template template = TemplateFactory.forLocation((String)location);
            TemplateFiles resources = new TemplateFiles(template);
            File f = new File(resources.getWebApp(), location);
            String type = req.getParameter((Parameter)StandardParameters.type);
            boolean isFolder = type != null ? "folder".equals(type) : FilenameUtils.getExtension((String)location).length() == 0;
            TemplateFiles.Zone zone = TemplateFiles.getZone((Template)template, (String)location);
            boolean isAllowed = zone != null && Files.isDescendantOf((File)resources.get((TemplateZone)zone), (File)f);
            boolean created = false;
            xml.openElement("file");
            xml.attribute("name", f.getName());
            xml.attribute("path", location);
            if (template.isDefault() || !isAllowed) {
                xml.attribute("status", "forbidden");
            } else if (f.exists()) {
                res.setError(GeneratorStatus.BAD_REQUEST, "File already exist");
            } else {
                if (isFolder) {
                    xml.attribute("type", "folder");
                    created = f.mkdirs();
                } else {
                    xml.attribute("type", "file");
                    String media = Medias.getMediaType((File)f);
                    if (media != null) {
                        xml.attribute("mediatype", media);
                    }
                    created = f.createNewFile();
                    xml.attribute("length", "0");
                    xml.attribute("modified", ISO8601.DATETIME.format(f.lastModified()));
                    if (created) {
                        xml.attribute("status", "created");
                    }
                    TemplateHistory history = new TemplateHistory(resources);
                    history.backup((TemplateZone)zone, "/" + Files.path((File)resources.get((TemplateZone)zone), (File)f));
                }
                res.setStatus(created ? GeneratorStatus.CREATED : GeneratorStatus.OK);
            }
            xml.closeElement();
        } else {
            xml.emptyElement("no-style-owner");
        }
        xml.flush();
    }
}

