/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.content;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.util.Date;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(uri=true, database=true)
public final class GetLastChangeDate
implements Generator,
SingleCheck {
    private static final String[] ROLES_EQUALS = new String[]{"Documentation", "Comment", "File Upload", "File Attachment", "File Creation"};
    private static final String[] ROLES_STARTS_WITH = new String[]{"Documentation-%"};

    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewURICheck(req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        URI uri = req.getURI();
        Database db = req.getDatabase();
        Date latest = null;
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        if (fragment == null) {
            for (Locator loc : uri.getLocatorsCol()) {
                XLink last = DatabaseQuery.getXLinkByContentRoleLocatorLastChange((Database)db, (String[])ROLES_EQUALS, (String[])ROLES_STARTS_WITH, (Long)loc.getId());
                if (last == null || latest != null && !latest.after(last.getDate())) continue;
                latest = last.getDate();
            }
        } else {
            if (!URIRule.hasFragment((URI)uri, (Group)req.getGroup(), (String)fragment, (Database)req.getDatabase())) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + fragment);
                return;
            }
            Locator loc = LocatorRule.getLocatorByURIFragment((Database)db, (URI)uri, (String)fragment);
            XLink last = DatabaseQuery.getXLinkByContentRoleLocatorLastChange((Database)db, (String[])ROLES_EQUALS, (String[])ROLES_STARTS_WITH, (Long)loc.getId());
            Date date = latest = last != null ? last.getDate() : null;
        }
        if (latest == null) {
            latest = new Date();
        }
        XMLWriter xml = res.getXMLWriter();
        xml.element("datetime", ISO8601.format((long)latest.getTime(), (ISO8601)ISO8601.DATETIME));
        xml.flush();
    }
}

