/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.content;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.search.flint.IndexMaster;
import java.io.IOException;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.lucene.query.PredicateSearchQuery;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.pageseeder.xmlwriter.XMLWriter;

public final class GetLabelledDocuments
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String label = req.getParameter((Parameter)StandardParameters.label);
        try {
            IndexMaster master = IndexMaster.getInstance();
            if (!master.isIndexable(req.getDatabase(), req.getGroup())) {
                XMLWriter xml = res.getXMLWriter();
                xml.writeXML("<root><status>error</status><message>The group is not indexed.</message></root>");
                return;
            }
            PredicateSearchQuery pq = new PredicateSearchQuery("+pstype:document +pslabel:" + label.replaceAll(":", "\\:").replaceAll(" +", "_"));
            int hits_per_page = 20;
            SearchResults results = master.search(req.getDatabase(), req.getGroup(), (SearchQuery)pq, 20, 1);
            XMLWriter xml = res.getXMLWriter();
            results.toXML(xml);
            xml.flush();
        }
        catch (IndexException ex) {
            throw new IOException(ex);
        }
    }
}

