/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.XLink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReminderThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReminderThread.class);
    private static final int MAX_PAGE_SIZE = 2000;
    private static int[] reminderTime = new int[]{4, 0};
    private static int reminderMaxEmails = 2000;
    public static Calendar nextNotify = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String time = GlobalSettings.getString((String)"reminderTime", (String)"04:00");
        String[] ndt = RuleUtils.delimitedToArray((String)time, (String)":");
        try {
            ReminderThread.reminderTime[0] = Integer.parseInt(ndt[0]);
            ReminderThread.reminderTime[1] = Integer.parseInt(ndt[1]);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Global property reminderTime is invalid: {}", (Object)time, (Object)ex);
            return;
        }
        GregorianCalendar current = new GregorianCalendar();
        nextNotify = new GregorianCalendar(current.get(1), current.get(2), current.get(5), reminderTime[0], reminderTime[1]);
        while (current.after(nextNotify) || nextNotify.get(7) != 2) {
            nextNotify.add(5, 1);
        }
        List<String> statuses = Arrays.asList(GlobalSettings.getString((String)"reminderStatuses", (String)"Open").split(","));
        String maxEmails = GlobalSettings.getString((String)"reminderMaxEmails", (String)"2000");
        try {
            reminderMaxEmails = Integer.parseInt(maxEmails);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Global property reminderMaxEmails is invalid: {}", (Object)maxEmails, (Object)ex);
            return;
        }
        LOGGER.info("Reminder Thread Started");
        boolean stopped = false;
        while (true) {
            if (current.after(nextNotify)) {
                nextNotify.add(5, 7);
                Database db = null;
                try {
                    db = Database.open();
                }
                catch (OpenDatabaseException ex) {
                    LOGGER.error("Unable to open database", (Throwable)ex);
                    db = null;
                    return;
                }
                Transaction tr = new Transaction(db);
                try {
                    tr.begin();
                    HashMap memberTasks = new HashMap();
                    GregorianCalendar dueAfter = new GregorianCalendar();
                    dueAfter.set(10, 0);
                    dueAfter.set(12, 0);
                    dueAfter.set(13, 0);
                    Calendar dueBefore = (Calendar)((Calendar)dueAfter).clone();
                    ((Calendar)dueAfter).add(1, -1);
                    dueBefore.add(5, 31);
                    int page = 1;
                    boolean limit = false;
                    while (true) {
                        List xls = DatabaseQuery.getTasksByDuedateStatus((Database)db, (int)page, (int)2000, (Date)dueAfter.getTime(), (Date)dueBefore.getTime(), statuses, (boolean)true);
                        for (XLink xl : xls) {
                            Member mem = xl.getAssignedTo();
                            if (mem == null || !MemberRule.hasEmail((Member)mem)) continue;
                            ArrayList<Emails.ReminderTask> tasks = (ArrayList<Emails.ReminderTask>)memberTasks.get(mem.getId());
                            if (tasks == null) {
                                tasks = new ArrayList<Emails.ReminderTask>();
                            } else if (tasks.size() > 25) continue;
                            Collection groups = XLinkRule.getGroups((XLink)xl);
                            UserDetails userDetails = new UserDetailsManager().get(db, mem.getId(), false);
                            groups = MemberRule.removeNonMemberGroups((Collection)groups, (Map)userDetails.flags());
                            Group reminderGroup = null;
                            for (Group group : groups) {
                                try {
                                    Membership membership;
                                    Properties groupProps = GroupProperties.get((Database)db, (Group)group);
                                    if (!"true".equals(groupProps.get("reminderNotification")) || (membership = MemberForGroupRule.getMembership((Group)group, (Member)mem, (boolean)true, (boolean)false, (Database)db)) == null || membership.getNotification() == Notification.NONE) continue;
                                    reminderGroup = group;
                                    break;
                                }
                                catch (Exception ex) {
                                    LOGGER.error("Unable to load details for group: {}, member: {}", new Object[]{group.getName(), mem.getId(), ex});
                                }
                            }
                            if (reminderGroup != null) {
                                if (tasks.isEmpty() && memberTasks.size() >= reminderMaxEmails) {
                                    LOGGER.error("Reminders exceed limit, consider increasing reminderMaxEmails global property");
                                    limit = true;
                                    break;
                                }
                                tasks.add(new Emails.ReminderTask(xl.getId().longValue(), reminderGroup.getId().longValue()));
                                memberTasks.put(mem.getId(), tasks);
                            }
                            if (!Thread.interrupted()) continue;
                            stopped = true;
                            break;
                        }
                        if (xls.size() <= 2000 || limit || stopped) break;
                        ++page;
                        tr.commitAndStart();
                    }
                    tr.commitAndStart();
                    if (Thread.interrupted()) {
                        stopped = true;
                    }
                    if (stopped) break;
                    String template = GlobalSettings.getGlobalTemplate();
                    Group project = template == null ? null : DatabaseQuery.getGroupByName((Database)db, (String)template);
                    for (Map.Entry mt : memberTasks.entrySet()) {
                        Member member = DatabaseQuery.getMemberById((Database)db, (Long)((Long)mt.getKey()));
                        if (member != null) {
                            try {
                                Emails.sendReminderDigest((Database)db, (Group)project, (List)((List)mt.getValue()), (Member)member);
                            }
                            catch (Exception ex) {
                                LOGGER.error("Unable to send reminder for member: {}", (Object)member.getId(), (Object)ex);
                            }
                        }
                        tr.commitAndStart();
                        if (!Thread.interrupted()) continue;
                        stopped = true;
                        break;
                    }
                    tr.commit();
                }
                catch (StartTransactionException ex) {
                    LOGGER.error("Unable to start transaction", (Throwable)ex);
                }
                catch (DatabaseException ex) {
                    LOGGER.error("Database error", (Throwable)ex);
                    tr.abort();
                }
                finally {
                    db.close();
                    db = null;
                }
            }
            if (stopped) break;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException ex) {
                break;
            }
            current = new GregorianCalendar();
        }
        LOGGER.info("Notification Thread Stopped");
    }
}

