/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.comment.Comments;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.XML, OutputType.JSON})
public final class GetDiscussionsByFilter
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 1000L;
    private static final long DEFAULT_DISCUSSION_SIZE = 100L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GetDiscussionsByFilter.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        NoCheck check = new NoCheck();
        if ("all".equals(req.getParameter((Parameter)StandardParameters.emails))) {
            check = new ManageAccountCheck();
        }
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)check);
        }
        return check;
    }

    /*
     * WARNING - void declaration
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        void var28_31;
        Collection<Object> groupnames;
        String groups = req.getParameter((Parameter)StandardParameters.groups, null);
        String project = req.getParameter((Parameter)StandardParameters.project, null);
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int discussion_size = (int)req.getParameter((Parameter)StandardParameters.discussionsize, 100L);
        String context = req.getParameter((Parameter)StandardParameters.context, "all");
        String comments = req.getParameter((Parameter)StandardParameters.comments, "last");
        String contents = req.getParameter((Parameter)StandardParameters.contents, "all");
        String attachments = req.getParameter((Parameter)StandardParameters.attachments, "all");
        String emails = req.getParameter((Parameter)StandardParameters.emails, "none");
        String paths = req.getParameter((Parameter)StandardParameters.paths, null);
        String title = req.getParameter((Parameter)StandardParameters.title, null);
        String type = req.getParameter((Parameter)StandardParameters.type, null);
        String types = req.getParameter((Parameter)StandardParameters.types);
        Long author = req.getParameter((Parameter)StandardParameters.author, -1L);
        String createdafter = req.getParameter((Parameter)StandardParameters.createdafter, null);
        String createdbefore = req.getParameter((Parameter)StandardParameters.createdbefore, null);
        String labels = req.getParameter((Parameter)StandardParameters.labels, null);
        if (!Comments.checkLabels(res, labels)) {
            return;
        }
        Database db = req.getDatabase();
        UserDetails userdetails = req.getMember() != null ? new UserDetailsManager().get(db, req.getMember().getId(), false) : SecurityUtils.getDefaultUserDetails();
        ArrayList usergroups = new ArrayList(userdetails.flags().keySet());
        usergroups.remove("admin");
        Collection<Object> collection = groupnames = groups == null ? usergroups : Arrays.asList(groups.split(","));
        if (project != null) {
            groupnames = GroupRule.removeNonProjectGroupNames(groupnames, (String)project);
        }
        ArrayList<String> grps = new ArrayList<String>();
        ArrayList<Group> grpc = new ArrayList<Group>();
        for (String string : groupnames) {
            Group grp = DatabaseQuery.getGroupByName((Database)db, (String)string);
            if (grp == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Invalid group name: " + string);
                return;
            }
            if (groups == null) {
                if (grp.hasFlag('d')) {
                    continue;
                }
            } else if (!GroupRule.userHasAccess((Group)grp, (UserDetails)userdetails)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Not allowed to access group: " + string);
                return;
            }
            grps.add(grp.getName());
            grpc.add(grp);
        }
        List<String> pathsList = null;
        Object var28_29 = null;
        List<String> labelsList = null;
        if (paths != null) {
            pathsList = Arrays.asList(paths.split(","));
        }
        if ("group".equals(context)) {
            if (paths != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTEXT_AMBIGUOUS, "Context 'group' cannot be used with 'paths' parameter");
                return;
            }
            pathsList = new ArrayList<String>();
            for (Group g : grpc) {
                pathsList.add(GlobalSettings.get((String)"servletPrefix") + "/com.pageseeder.general/" + g.getId());
            }
        }
        if (types != null) {
            List<String> list = Arrays.asList(types.split(","));
        }
        if (labels != null) {
            labelsList = Arrays.asList(labels.split(","));
        }
        Member authormem = null;
        Member assignedtomem = null;
        if (!author.equals(-1L) && (authormem = this.loadMember(author, "author", db, res)) == null) {
            return;
        }
        Date createdAfterDate = null;
        Date createdBeforeDate = null;
        if (createdafter != null && (createdAfterDate = this.loadDate(createdafter, "createdafter", res)) == null) {
            return;
        }
        if (createdbefore != null && (createdBeforeDate = this.loadDate(createdbefore, "createdbefore", res)) == null) {
            return;
        }
        List discussions = DatabaseQuery.getDiscussionsByFilterParams((Database)db, (int)page, (int)pagesize, grpc, pathsList, (String)title, (String)type, (Collection)var28_31, (Member)authormem, assignedtomem, (Date)createdAfterDate, (Date)createdBeforeDate, labelsList, (!"uri".equals(context) ? 1 : 0) != 0);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("discussions");
        out.startCollection("discussions", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Discussion discussion : discussions) {
            if ("all".equals(comments)) {
                discussion.loadAllComments(db, discussion_size);
            } else if ("first".equals(comments)) {
                discussion.loadFirstComment(db);
            } else if ("last".equals(comments)) {
                discussion.loadLastComment(db, true);
            } else if ("archive".equals(comments)) {
                discussion.loadArchiveComments(db, discussion_size);
            }
            discussion.loadUri(db, null);
            out.writeDiscussion(discussion, "discussion", db, grpc, "all".equals(contents), "all".equals(attachments), "all".equals(emails), null);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    private Date loadDate(String dateValue, String dateName, GeneratorResponse res) {
        try {
            return ISO8601.DATETIME.parse(dateValue);
        }
        catch (ParseException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.DATE_INVALID, "The " + dateName + " date is invalid: " + dateValue);
            return null;
        }
    }

    private Member loadMember(long memID, String memParam, Database db, GeneratorResponse res) {
        Member mem = null;
        try {
            mem = DatabaseQuery.getMemberById((Database)db, (Long)memID);
        }
        catch (QueryFailedException e) {
            LOGGER.error("Failed to load member with id ", (Object)memID, (Object)e);
        }
        if (mem == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.MEMBER_INVALID, "The " + memParam + " id is not valid: " + memID);
        }
        return mem;
    }
}

