/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.comment.Comments;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.XLink;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.XML, OutputType.JSON})
public final class GetCommentsByFilter
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetCommentsByFilter.class);
    private static final long DEFAULT_MAX_NB = 1000L;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        NoCheck check = new NoCheck();
        if ("all".equals(req.getParameter((Parameter)StandardParameters.emails))) {
            check = new ManageAccountCheck();
        }
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)check);
        }
        return check;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String groups = req.getParameter((Parameter)StandardParameters.groups);
        if (groups == null && req.getGroup() != null) {
            groups = req.getGroup().getName();
        }
        if (groups == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Missing context group");
            return;
        }
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        String returngroups = req.getParameter((Parameter)StandardParameters.returngroups);
        String contents = req.getParameter((Parameter)StandardParameters.contents, "all");
        String attachments = req.getParameter((Parameter)StandardParameters.attachments, "all");
        String emails = req.getParameter((Parameter)StandardParameters.emails, "none");
        String context = req.getParameter((Parameter)StandardParameters.context, "all");
        String paths_param = req.getParameter((Parameter)StandardParameters.paths, null);
        String title = req.getParameter((Parameter)StandardParameters.title, null);
        String type = req.getParameter((Parameter)StandardParameters.type, null);
        String types = req.getParameter((Parameter)StandardParameters.types);
        Long author = req.getParameter((Parameter)StandardParameters.author, -1L);
        String createdafter = req.getParameter((Parameter)StandardParameters.createdafter, null);
        String createdbefore = req.getParameter((Parameter)StandardParameters.createdbefore, null);
        boolean archived = req.getParameter((Parameter)StandardParameters.archived, false);
        boolean moderated = req.getParameter((Parameter)StandardParameters.moderated, false);
        String labels = req.getParameter((Parameter)StandardParameters.labels, null);
        String position = req.getParameter((Parameter)StandardParameters.position, "any");
        String statuses = req.getParameter((Parameter)StandardParameters.statuses, null);
        if (!Comments.checkLabels(res, labels)) {
            return;
        }
        Database db = req.getDatabase();
        UserDetails userdetails = req.getMember() != null ? new UserDetailsManager().get(db, req.getMember().getId(), false) : SecurityUtils.getDefaultUserDetails();
        String[] groupnames = groups.split(",");
        ArrayList<String> grps = new ArrayList<String>();
        ArrayList<Group> grpc = new ArrayList<Group>();
        for (String groupname : groupnames) {
            Group grp = DatabaseQuery.getGroupByName((Database)db, (String)groupname);
            if (grp == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Invalid group name: " + (String)groupname);
                return;
            }
            if (!GroupRule.userHasAccess((Group)grp, (UserDetails)userdetails)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Not allowed to access group: " + (String)groupname);
                return;
            }
            grps.add(grp.getName());
            grpc.add(grp);
        }
        List<String> paths = null;
        List<String> statusesList = null;
        List<String> typesList = null;
        if (paths_param != null) {
            paths = Arrays.asList(paths_param.split(","));
        }
        if ("group".equals(context)) {
            if (paths_param != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTEXT_AMBIGUOUS, "Context 'group' cannot be used with 'paths' parameter");
                return;
            }
            paths = new ArrayList<String>();
            for (Group g : grpc) {
                paths.add(GlobalSettings.get((String)"servletPrefix") + "/com.pageseeder.general/" + g.getId());
            }
        }
        if (types != null) {
            typesList = Arrays.asList(types.split(","));
        }
        if (statuses != null) {
            statusesList = Arrays.asList(statuses.split(","));
        }
        Member authormem = null;
        if (!author.equals(-1L) && (authormem = DatabaseQuery.getMemberById((Database)db, (Long)author)) == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.MEMBER_INVALID, "The author id is not valid: " + author);
            return;
        }
        Date after = null;
        try {
            if (createdafter != null) {
                after = ISO8601.DATETIME.parse(createdafter);
            }
        }
        catch (ParseException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.DATE_INVALID, "The createdafter date is invalid: " + createdafter);
            return;
        }
        Date before = null;
        try {
            if (createdbefore != null) {
                before = ISO8601.DATETIME.parse(createdbefore);
            }
        }
        catch (ParseException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.DATE_INVALID, "The createdbefore date is invalid: " + createdbefore);
            return;
        }
        List comments = DatabaseQuery.getCommentsByFilterParams((Database)db, (int)page, (int)pagesize, grps, paths, (String)title, (String)type, typesList, (Member)authormem, (Date)after, (Date)before, (boolean)archived, (boolean)moderated, (String)labels, (boolean)"first".equals(position), statusesList, (!"uri".equals(context) ? 1 : 0) != 0);
        if (returngroups == null) {
            returngroups = grpc.size() > 1 ? "specified" : "none";
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("comments");
        out.startCollection("comments", OutputPrinter.CollectionOption.JSON_ONLY);
        long pbefore = System.currentTimeMillis();
        for (XLink comment : comments) {
            out.writeComment(comment, (Database)("all".equals(attachments) || "context".equals(attachments) ? db : null), null, "specified".equals(returngroups) ? grpc : null, true, "all".equals(contents), "all".equals(attachments), "all".equals(emails));
        }
        GetCommentsByFilter.profiling("printing comments", comments.size(), pbefore);
        out.endCollection();
        out.endObject();
        out.flush();
    }

    private static void profiling(String name, int count, long before) {
        long after = System.currentTimeMillis();
        long diff = after - before;
        if (diff > DatabaseQuery.profiling) {
            LOGGER.warn(name + ": " + count + " ---> " + diff + "ms.");
        }
    }
}

