/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.comment.Comments;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.XLink;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

@Output(types={OutputType.XML, OutputType.JSON})
public final class GetCommentDrafts
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 10L;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 10L);
        Database db = req.getDatabase();
        List comments = DatabaseQuery.getCommentDraftsByMember((Database)db, (int)page, (int)pagesize, (Long)req.getMember().getId(), (boolean)true);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("comments");
        out.startCollection("comments", OutputPrinter.CollectionOption.JSON_ONLY);
        if (comments.size() == pagesize + 1) {
            out.field("limitreached", true);
            comments.remove(pagesize);
        }
        Collection<Group> groups = Comments.getReturnGroups(req);
        for (XLink comment : comments) {
            out.writeComment(comment, db, null, groups, true, true, false, false);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

