/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.util.PublicAPI;

@PublicAPI
public enum CommentErrorID implements ErrorID
{
    NO_GENERAL_DISCUSSION(25345, "The group has no general discussion."),
    CREATE_FAILED(25346, "Failed to create new comment."),
    EDIT_FAILED(25347, "Failed to edit comment."),
    ARCHIVE_FAILED(25348, "Failed to archive comment."),
    UNARCHIVE_FAILED(25349, "Failed to unarchive comment."),
    NO_CONTEXT_URI(25350, "The comment has no context URI."),
    AUTHOR_MISSING(4865, "Author missing."),
    AUTHOR_EXISTING(4866, "Existing author, login to use these details."),
    CONTEXT_AMBIGUOUS(4867, "More than one comment context has been been specified."),
    URL_INVALID(4868, "The URL is invalid."),
    URL_WITH_NO_GROUPURI(4869, "The URL does not match a GroupURI."),
    GROUP_INVALID(4870, "The Group is invalid."),
    ASSIGNEDTO_INVALID(4871, "The assigned to member is invalid."),
    DUEDATE_INVALID(4872, "The due date is invalid."),
    COMMENT_ARCHIVED(4873, "The comment is already archived"),
    COMMENT_NOT_ARCHIVED(4880, "The comment is not archived."),
    NOT_A_COMMENT(4881, "The object specified is not a comment."),
    DATE_INVALID(4882, "The date is invalid."),
    MEMBER_INVALID(4883, "The member is invalid."),
    URL_NOT_SPECIFIED(4884, "The URL was not specified."),
    URL_NOT_FOUND(4885, "The URL was not found."),
    DISCUSSION_NOT_FOUND(4886, "The discussion was not found."),
    COMMENT_NOT_FOUND(4887, "The comment was not found."),
    URI_NOT_FOUND(4888, "URI not found."),
    NOT_A_VERSION(4889, "The object specified is not a version."),
    VERSION_ON_DIFFERENT_URI(4896, "The version is attached to a different URI."),
    NOT_AN_XREF(4897, "The object specified is not an XRef."),
    XREF_ON_DIFFERENT_URI(4898, "The XRef is attached to a different URI."),
    DRAFT_ALREADY_EXISTS(4899, "A draft already exists for this discussion/workflow."),
    REPLY_TO_ITSELF(4900, "Comment can't be a reply to itself."),
    TASK_NOT_FOUND(4901, "The task was not found."),
    CONTENT_INVALID(4902, "The content was invalid."),
    WORKFLOW_EDIT_NOT_ALLOWED(4903, "Only some fields can be edited for workflow steps."),
    LABELS_INVALID(4904, "Invalid labels - must follow pattern [a-zA-Z0-9_\\-,]*"),
    PRIORITY_INVALID(4905, "Invalid priority - must follow pattern [a-zA-Z0-9, _-]+"),
    STATUS_INVALID(4912, "Invalid status - must follow pattern [a-zA-Z0-9, _-]+");

    private final int _id;
    private final String _message;

    private CommentErrorID(int id, String message) {
        if (id < 0) {
            throw new IndexOutOfBoundsException("Error ID must be >= 0");
        }
        this._id = id;
        this._message = message;
    }

    public int id() {
        return this._id;
    }

    public String message() {
        return this._message;
    }
}

