/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.cache;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import java.io.IOException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;

@Output(types={OutputType.XML, OutputType.JSON})
public final class ClearCache
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String name = req.getParameter((Parameter)StandardParameters.name);
        UniversalPrinter out = res.getUniversalWriter();
        CacheManager manager = CacheManager.getInstance();
        out.startObject("clear-cache");
        if (name != null) {
            Ehcache cache = manager.getEhcache(name);
            if (cache == null) {
                res.setError(GeneratorStatus.NOT_FOUND, "Cache not found with specified 'name'.");
                return;
            }
            SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.OTHER, (String)"Clearing cache '{}'", (Object[])new Object[]{cache.getName()});
            cache.removeAll();
            ClearCache.print(cache, (OutputPrinter)out);
        } else {
            manager.clearAll();
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.OTHER, (String)"Clearing all caches");
            String[] names = manager.getCacheNames();
            out.startCollection("caches", OutputPrinter.CollectionOption.JSON_ONLY);
            for (String n : names) {
                Ehcache cache = manager.getEhcache(n);
                ClearCache.print(cache, (OutputPrinter)out);
            }
            out.endCollection();
        }
        out.endObject();
        out.flush();
    }

    private static void print(Ehcache cache, OutputPrinter out) {
        if (cache == null) {
            return;
        }
        out.startObject("cache");
        out.field("name", cache.getName());
        out.field("guid", cache.getGuid());
        out.endObject();
    }
}

