/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai.core;

import com.pageseeder.ai.core.IntelligenceConfigException;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.db.model.Group;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class RedactionEngine {
    private final Map<String, String> forward;
    private final Map<String, String> backward;

    RedactionEngine(Properties properties) {
        this.forward = properties.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), properties::getProperty));
        this.backward = properties.stringPropertyNames().stream().collect(Collectors.toMap(properties::getProperty, Function.identity()));
    }

    public static RedactionEngine getInstance(Group group) throws IntelligenceConfigException {
        TemplateFiles resources = new TemplateFiles(group.getOwnerDirectory());
        File promptFile = resources.findFile("ai/redaction.properties");
        Properties properties = new Properties();
        if (promptFile != null && promptFile.exists()) {
            try (FileReader reader = new FileReader(promptFile, StandardCharsets.UTF_8);){
                properties.load(reader);
            }
            catch (Exception ex) {
                throw new IntelligenceConfigException("Unable to load redaction rules");
            }
        }
        return new RedactionEngine(properties);
    }

    public InputStream redact(InputStream in) throws IOException {
        return RedactionEngine.swap(in, this.forward);
    }

    public InputStream unRedact(InputStream in) throws IOException {
        return RedactionEngine.swap(in, this.backward);
    }

    public String redact(String in) {
        return RedactionEngine.swap(in, this.forward);
    }

    public String unRedact(String in) {
        return RedactionEngine.swap(in, this.backward);
    }

    private static InputStream swap(InputStream in, Map<String, String> map) throws IOException {
        if (map.isEmpty()) {
            return in;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                out.write(RedactionEngine.swap(line, map).getBytes(StandardCharsets.UTF_8));
                line = reader.readLine();
                if (line == null) continue;
                out.write(10);
            }
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    private static String swap(String in, Map<String, String> map) {
        if (in.isEmpty() || map.isEmpty()) {
            return in;
        }
        StringBuilder result = new StringBuilder(in);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            int index;
            String key = entry.getKey();
            String value = entry.getValue();
            int start = 0;
            while ((index = result.indexOf(key, start)) != -1) {
                result.replace(index, index + key.length(), value);
                start = index + value.length();
            }
        }
        return result.toString();
    }
}

