/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai.core;

import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.PSML;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.pageseeder.ai.prompt.Attachment;
import net.pageseeder.ai.prompt.Content;
import net.pageseeder.ai.prompt.ContentSpec;
import net.pageseeder.ai.prompt.Prompt;
import net.pageseeder.ai.prompt.PromptTemplate;
import net.pageseeder.ai.prompt.TextTemplate;
import net.pageseeder.ai.prompt.XmlFormat;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Prompts {
    private static final Logger LOGGER = LoggerFactory.getLogger(Prompts.class);

    private Prompts() {
    }

    public static boolean isValidPromptId(@Nullable String promptId) {
        return promptId == null || promptId.matches("^\\w{1,63}$");
    }

    public static @Nullable PromptTemplate getPromptTemplate(@Nullable String promptId, Group group) {
        if (promptId == null || !Prompts.isValidPromptId(promptId)) {
            return null;
        }
        TemplateFiles resources = new TemplateFiles(group.getOwnerDirectory());
        File promptFile = resources.findFile("ai" + File.separator + "prompt" + File.separator + promptId + ".xml");
        if (promptFile == null) {
            return null;
        }
        try {
            return XmlFormat.parse((File)promptFile);
        }
        catch (IOException | ParseException ex) {
            LOGGER.error("Unable to parse prompt file", (Throwable)ex);
            return null;
        }
    }

    public static @Nullable PromptTemplate getPromptTemplate(@Nullable String promptId, URI uri, Group group) {
        File file = Prompts.getPromptFile(promptId, uri, group);
        if (file == null) {
            return null;
        }
        try {
            return XmlFormat.parse((File)file);
        }
        catch (IOException | ParseException ex) {
            LOGGER.error("Unable to parse prompt file", (Throwable)ex);
            return null;
        }
    }

    public static @Nullable File getPromptFile(@Nullable String promptId, URI uri, Group group) {
        File file;
        if (promptId == null || !Prompts.isValidPromptId(promptId)) {
            return null;
        }
        String template = GroupRule.getTemplate((Group)group);
        String type = URIRule.getStyleConfig((URI)uri);
        if (type == null) {
            type = "default";
        }
        String extension = PSML.getFileExtension(uri);
        TemplateFiles projectFiles = new TemplateFiles(template);
        if (URIRule.isPSML((URI)uri) && (file = projectFiles.findFile("psml/" + type + "/prompt/" + promptId + ".xml")) != null) {
            return file;
        }
        file = projectFiles.findFile("document/" + extension + "/prompt/" + promptId + ".xml");
        if (file != null) {
            return file;
        }
        file = projectFiles.findFile("ai/prompt/" + promptId + ".xml");
        return file;
    }

    public static List<PromptTemplate> listPromptTemplates(URI uri, Group group) {
        ArrayList<PromptTemplate> prompts = new ArrayList<PromptTemplate>();
        List<File> files = Prompts.listPromptFiles(uri, group);
        for (File f : files) {
            try {
                PromptTemplate template = XmlFormat.parse((File)f);
                if (!f.getName().equals(template.getId() + ".xml")) {
                    LOGGER.warn("Prompt ID `{}` does not file name: {}", (Object)template.getId(), (Object)f.getName());
                }
                prompts.add(template);
            }
            catch (IOException | ParseException ex) {
                LOGGER.error("Unable to parse prompt file", (Throwable)ex);
            }
        }
        return prompts;
    }

    public static List<File> listPromptFiles(URI uri, Group group) {
        if (URIRule.isFolder((URI)uri) || URIs.isExternal((URI)uri)) {
            return Collections.emptyList();
        }
        ArrayList<File> prompts = new ArrayList<File>();
        HashSet<String> names = new HashSet<String>();
        String template = GroupRule.getTemplate((Group)group);
        String type = URIRule.getStyleConfig((URI)uri);
        if (type == null) {
            type = "default";
        }
        String extension = PSML.getFileExtension(uri);
        TemplateFiles projectFiles = new TemplateFiles(template);
        if (URIRule.isPSML((URI)uri)) {
            Prompts.collect(projectFiles.getFile("psml/" + type + "/prompt"), prompts, names);
        }
        Prompts.collect(projectFiles.getFile("document/" + extension + "/prompt"), prompts, names);
        Prompts.collect(projectFiles.getFile("ai/prompt"), prompts, names);
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        if (globalTemplate != null) {
            TemplateFiles globalFiles = new TemplateFiles(globalTemplate);
            if (URIRule.isPSML((URI)uri)) {
                Prompts.collect(globalFiles.getFile("psml/" + type + "/prompt"), prompts, names);
            }
            Prompts.collect(globalFiles.getFile("document/" + extension + "/prompt"), prompts, names);
            Prompts.collect(globalFiles.getFile("ai/prompt"), prompts, names);
        }
        return prompts;
    }

    private static void collect(@Nullable File dir, List<File> prompts, Set<String> names) {
        File[] files;
        if (dir != null && dir.exists() && dir.isDirectory() && (files = dir.listFiles((d, name) -> name.endsWith(".xml") && Prompts.isValidPromptId(name.substring(0, name.length() - 4)))) != null) {
            for (File f : files) {
                if (names.contains(f.getName())) continue;
                prompts.add(f);
            }
        }
    }

    public static void printPromptTemplate(OutputPrinter out, PromptTemplate prompt) {
        out.startObject("prompt-template");
        out.field("id", prompt.getId());
        out.field("type", prompt.getType());
        out.field("max-tokens", (long)prompt.getMaxTokens());
        out.field("temperature", Double.toString(prompt.getTemperature()));
        out.field("system", prompt.getSystem().template(), OutputPrinter.FieldOption.XML_ELEMENT);
        out.startCollection("placeholders");
        prompt.listPlaceholders().forEach(p -> {
            out.startObject("placeholder");
            out.field("name", p);
            out.endObject();
        });
        out.endCollection();
        out.startCollection("user");
        for (ContentSpec spec : prompt.getUser()) {
            if (spec instanceof TextTemplate) {
                out.field("text", ((TextTemplate)spec).template(), OutputPrinter.FieldOption.XML_ELEMENT);
                continue;
            }
            out.startObject("attachment");
            out.field("ref", ((Attachment)spec).ref());
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }

    public static void printPrompt(OutputPrinter out, Prompt prompt) {
        out.startObject("prompt");
        out.field("id", prompt.getId());
        out.field("type", prompt.getType());
        out.field("max-tokens", (long)prompt.getMaxTokens());
        out.field("temperature", Double.toString(prompt.getTemperature()));
        String model = prompt.getModel();
        if (model != null) {
            out.field("model", model);
        }
        out.field("system", prompt.getSystem(), OutputPrinter.FieldOption.XML_ELEMENT);
        out.startCollection("contents");
        for (Content content : prompt.getUser()) {
            out.startObject("content");
            out.field("mediatype", content.mediaType());
            if (content.isText()) {
                out.field("text", content.getText(), OutputPrinter.FieldOption.XML_ELEMENT);
            } else {
                out.field("bytes", content.getText());
            }
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }
}

