/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai;

import com.pageseeder.ai.core.AttachmentManager;
import com.pageseeder.ai.core.IntelligenceProvider;
import com.pageseeder.ai.core.Prompts;
import com.pageseeder.ai.core.RedactionEngine;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.util.HashMap;
import net.pageseeder.ai.prompt.Attachment;
import net.pageseeder.ai.prompt.ContentSpec;
import net.pageseeder.ai.prompt.Prompt;
import net.pageseeder.ai.prompt.PromptTemplate;
import net.pageseeder.ai.prompt.TextTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(uri=true, group=true, member=true, parameters={"prompt"})
public final class PreviewPrompt
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreviewPrompt.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewURICheck(req.getGroup(), req.getURI()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        IntelligenceProvider provider = IntelligenceProvider.getGlobal();
        if (provider == IntelligenceProvider.NONE) {
            res.setError(GeneratorStatus.NOT_IMPLEMENTED, "AI not supported");
            return;
        }
        String promptId = req.getParameter("prompt");
        HashMap<String, String> parameters = new HashMap<String, String>();
        req.getParameters().keySet().stream().filter(p -> p.startsWith("parameter.")).forEach(p -> parameters.put(p.substring(10), req.getParameter(p, "")));
        Database db = req.getDatabase();
        Member member = req.getMember();
        assert (member != null);
        URI uri = req.getURI();
        assert (uri != null);
        Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
        PromptTemplate template = Prompts.getPromptTemplate(promptId, uri, group);
        if (template == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid prompt ID");
            return;
        }
        boolean hasDocumentAttachment = template.listAttachmentRefs().contains("document");
        boolean includeDocument = req.getParameter("include-document", false);
        if (hasDocumentAttachment || includeDocument) {
            boolean isSupported = AttachmentManager.isSupportedType(uri);
            if (!isSupported) {
                res.setError(GeneratorStatus.BAD_REQUEST, "This type of document is not supported");
                return;
            }
            if (uri.getSize() != null && uri.getSize() > 10000000L) {
                res.setError(GeneratorStatus.BAD_REQUEST, "This document is too large");
                return;
            }
            AttachmentManager attachmentManager = new AttachmentManager(db, group, member);
            RedactionEngine redaction = RedactionEngine.getInstance(group);
            try {
                attachmentManager.setRedactionEngine(redaction);
                parameters.put("document", attachmentManager.asDataURI(uri));
                LOGGER.debug("Document included as attachment: {}", (Object)uri.getDisplayTitle());
            }
            catch (Exception ex) {
                LOGGER.error("Unable to attach document to prompt", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "AI not supported");
            }
            if (!hasDocumentAttachment) {
                if (uri.getType().startsWith("image")) {
                    template.addUser((ContentSpec)new TextTemplate("\nMy image is:\n"));
                } else {
                    template.addUser((ContentSpec)new TextTemplate("\nMy document is:\n"));
                }
                template.addUser((ContentSpec)new Attachment("document"));
            }
        }
        Prompt prompt = template.toPrompt(parameters);
        UniversalPrinter out = res.getUniversalWriter();
        Prompts.printPrompt((OutputPrinter)out, prompt);
        out.flush();
    }
}

