/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.db.Database;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.Member;
import com.pageseeder.publish.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActionProcessor<T extends DBObject> {
    private final Action<T> _action;
    private final Database _db;
    private final Transaction _tr;
    private final Map<String, String> _parameters = new HashMap<String, String>();
    private final String _groupName;
    private final String _memberUsername;
    private final Long _memberId;
    private final UserDetails _userDetails;
    private final String _userToken;
    private int _totalIds = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionProcessor.class);

    public ActionProcessor(String name, Map<String, String> params, Member member, String groupName, UserDetails details, String userToken, Database db, Transaction tr) {
        this._action = this.createAction(name);
        if (params != null) {
            this._parameters.putAll(params);
        }
        this._memberUsername = member.getUsername();
        this._memberId = member.getId();
        this._userDetails = details;
        this._userToken = userToken;
        this._groupName = groupName;
        this._db = db;
        this._tr = tr;
    }

    public final String getMemberUsername() {
        return this._memberUsername;
    }

    public final Long getMemberID() {
        return this._memberId;
    }

    public UserDetails getUserDetails() {
        return this._userDetails;
    }

    public String getUserToken() {
        return this._userToken;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public final int getTotalIDs() {
        return this._totalIds;
    }

    protected final String getParameter(String name) {
        return this._parameters.get(name);
    }

    protected final Map<String, String> getParametersPrefix(String prefix) {
        HashMap<String, String> prefixed = new HashMap<String, String>();
        for (String pname : this._parameters.keySet()) {
            if (!pname.startsWith(prefix)) continue;
            prefixed.put(pname.substring(prefix.length()), this._parameters.get(pname));
        }
        return prefixed;
    }

    public final ActionResult execute(Long[] ids) throws ActionException {
        this._totalIds = ids.length;
        Permissions perm = new Permissions();
        ProcessThread thread = null;
        Publisher publisher = null;
        if (this._action.isProcess()) {
            thread = this._action.initThread(this, this._db, this._tr);
        } else {
            publisher = this._action.initPublisher(this, this._db, this._tr);
        }
        ActionResult result = new ActionResult();
        for (Long id : ids) {
            T o = this.loadObject(this._db, id);
            if (o == null) continue;
            PermissionCheck check = this._action.permissionCheck(o);
            if (!PermissionManager.check((Long)this._memberId, (UserDetails)this._userDetails, (Database)this._db, (Permissions)perm, (PermissionCheck)check)) {
                result.disallowed.add(id);
                if (result.disallowed.size() <= 10) continue;
                break;
            }
            this._action.addObject(o, this._db);
        }
        if (!result.disallowed.isEmpty()) {
            return result;
        }
        if (thread != null) {
            ProcessManager manager = ProcessManager.getInstance();
            manager.start(thread);
            result.thread = thread;
        } else if (publisher != null) {
            try {
                publisher.run();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to run batch action publisher", (Throwable)ex);
                throw new ActionException("Failed to run publisher: " + ex.getMessage() + ".", ex);
            }
            result.publisherResponse = publisher.getResponse();
        } else {
            throw new ActionException("Invalid state with no thread or publisher.");
        }
        return result;
    }

    protected abstract Action<T> createAction(String var1);

    protected abstract T loadObject(Database var1, Long var2) throws ActionException;

    protected static class ActionResult {
        private final Collection<Long> disallowed = new ArrayList<Long>();
        private ProcessThread thread = null;
        private String publisherResponse = null;

        protected ActionResult() {
        }

        public Collection<Long> getDisallowed() {
            return this.disallowed;
        }

        public ProcessThread getThread() {
            return this.thread;
        }

        public String getPublisherResponse() {
            return this.publisherResponse;
        }
    }
}

