/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.properties.Settings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdateConfigs {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateConfigs.class);
    private static final String EXPORT_CONFIG_PATH = "document" + File.separator + "psml" + File.separator + "export";
    private static final String UPLOAD_CONFIG_PATH = "document" + File.separator + "docx" + File.separator + "upload";

    public static void convertAllEditorConfigs() {
        LOGGER.info("Converting all editor-config.json config files to XML");
        File dir = new File(Settings.getContextPath() + "WEB-INF" + File.separator + "template");
        UpdateConfigs.convertEditorConfigs(dir);
    }

    public static void convertEditorConfigs(File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                UpdateConfigs.convertEditorConfigs(file);
                continue;
            }
            if (!"editor-config.json".equals(file.getName())) continue;
            File target = new File(dir, "editor-config.xml");
            if (target.exists()) {
                LOGGER.error("Unable to convert file as editor-config.xml already exists for {}", (Object)file.getAbsolutePath());
                continue;
            }
            LOGGER.info("Converting {}/editor-config.json to XML", (Object)file.getParentFile().getName());
            boolean delete = false;
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(target), StandardCharsets.UTF_8);){
                XMLWriterImpl xml = new XMLWriterImpl((Writer)out);
                xml.setIndentChars("  ");
                UpdateConfigs.convertEditorConfigJsonToXml((XMLWriter)xml, file);
                xml.flush();
            }
            catch (Exception ex) {
                LOGGER.error("Unable to convert file {} error: {}", (Object)file.getAbsolutePath(), (Object)ex.getMessage());
                delete = true;
            }
            if (!delete || !target.exists()) continue;
            target.delete();
        }
    }

    public static void convertEditorConfigJsonToXml(XMLWriter xml, File json) throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        JsonNode node = mapper.readTree(json);
        xml.openElement("editor-configs", true);
        UpdateConfigs.convertXRefConfig(xml, node.get("PSMLXRefsConfig"));
        UpdateConfigs.convertFieldsConfig(xml, "PSMLProperties", node.get("PSMLPropertiesConfig"));
        UpdateConfigs.convertFieldsConfig(xml, "PSMLMetadata", node.get("PSMLMetadataConfig"));
        UpdateConfigs.convertFieldsConfig(xml, "PSMLLabelValues", node.get("PSMLLabelValuesConfig"));
        xml.closeElement();
    }

    private static void convertXRefConfig(XMLWriter xml, @Nullable JsonNode psmlxref) throws IOException {
        if (psmlxref == null) {
            return;
        }
        xml.openElement("editor-config", true);
        xml.attribute("name", "PSMLXRefs");
        Iterator topentries = psmlxref.fields();
        while (topentries.hasNext()) {
            Map.Entry topentry = (Map.Entry)topentries.next();
            xml.openElement("xref-config", true);
            xml.attribute("fragmenttype", (String)topentry.getKey());
            JsonNode topnode = (JsonNode)topentry.getValue();
            JsonNode node = topnode.get("xref");
            if (node != null) {
                xml.openElement("xref", true);
                Iterator entries = node.fields();
                while (entries.hasNext()) {
                    Map.Entry entry = (Map.Entry)entries.next();
                    String name = (String)entry.getKey();
                    String value = ((JsonNode)entry.getValue()).asText();
                    if ("reversetype".equals(name)) continue;
                    if ("manualtitle".equals(name)) {
                        name = "title";
                    }
                    if ("type".equals(name)) {
                        value = value.toLowerCase();
                    }
                    xml.attribute(name, value);
                }
                xml.closeElement();
            }
            if ((node = topnode.get("autosuggest")) != null) {
                UpdateConfigs.convertAutoSuggest(xml, node);
            }
            xml.closeElement();
        }
        xml.closeElement();
    }

    private static void convertFieldsConfig(XMLWriter xml, String name, @Nullable JsonNode psmlfields) throws IOException {
        if (psmlfields == null) {
            return;
        }
        xml.openElement("editor-config", true);
        xml.attribute("name", name);
        JsonNode fields = psmlfields.get("fields");
        if (fields != null) {
            Iterator entries = fields.fields();
            while (entries.hasNext()) {
                Map.Entry entry = (Map.Entry)entries.next();
                UpdateConfigs.convertField(xml, (String)entry.getKey(), (JsonNode)entry.getValue());
            }
        }
        xml.closeElement();
    }

    private static void convertField(XMLWriter xml, String fieldname, JsonNode field) throws IOException {
        JsonNode values;
        xml.openElement("field", true);
        xml.attribute("name", fieldname);
        Iterator entries = field.fields();
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry)entries.next();
            String name = (String)entry.getKey();
            if (!"label".equals(name) && !"type".equals(name) && !"placeholder".equals(name) && !"pattern".equals(name) && !"autocomplete".equals(name) && !"unique".equals(name) && !"readonly".equals(name)) continue;
            xml.attribute(name, ((JsonNode)entry.getValue()).asText());
        }
        JsonNode autosuggest = field.get("autosuggest");
        if (autosuggest != null) {
            xml.openElement("xref-config", true);
            UpdateConfigs.convertAutoSuggest(xml, autosuggest);
            xml.closeElement();
        }
        if ((values = field.get("values")) != null) {
            for (JsonNode node : values) {
                xml.element("value", node.asText());
            }
        }
        xml.closeElement();
    }

    private static void convertAutoSuggest(XMLWriter xml, JsonNode autosuggest) throws IOException {
        String documenttype = null;
        String folder = null;
        String group = null;
        xml.openElement("autosuggest", false);
        JsonNode node = autosuggest.get("group");
        if (node != null) {
            group = node.asText();
        }
        if ((node = autosuggest.get("fields")) != null) {
            xml.attribute("questionfields", UpdateConfigs.childrenToCommaSeparated(node));
        }
        if ((node = autosuggest.get("display")) != null) {
            xml.attribute("displayfields", UpdateConfigs.childrenToCommaSeparated(node));
        }
        node = autosuggest.get("with");
        StringBuilder filters = new StringBuilder();
        if (node != null) {
            Iterator entries = node.fields();
            boolean first = true;
            while (entries.hasNext()) {
                Map.Entry entry = (Map.Entry)entries.next();
                String name = (String)entry.getKey();
                String value = ((JsonNode)entry.getValue()).asText();
                if ("psancestor".equals(name)) {
                    folder = value;
                    continue;
                }
                if ("psdocumenttype".equals(name)) {
                    documenttype = value;
                    continue;
                }
                if (!first) {
                    filters.append(",");
                }
                filters.append(name).append(":").append(value);
                first = false;
            }
        }
        xml.closeElement();
        if (group != null || documenttype != null || folder != null || filters.length() != 0) {
            xml.openElement("target", false);
            if (group != null) {
                xml.attribute("group", group);
            }
            if (documenttype != null) {
                xml.attribute("documenttype", documenttype);
            }
            if (folder != null) {
                xml.attribute("folder", folder);
            }
            if (filters.length() != 0) {
                xml.attribute("filters", filters.toString());
            }
            xml.closeElement();
        }
    }

    private static String childrenToCommaSeparated(JsonNode node) {
        StringBuilder res = new StringBuilder();
        Iterator children = node.iterator();
        while (children.hasNext()) {
            JsonNode child = (JsonNode)children.next();
            res.append(child.asText());
            if (!children.hasNext()) continue;
            res.append(",");
        }
        return res.toString();
    }

    public static void moveLogFiles() throws IOException {
        File web_inf_dir = new File(Settings.getContextPath() + "WEB-INF");
        File new_state_dir = new File(web_inf_dir, "state");
        File oldlogs = new File(web_inf_dir, "logs");
        File newlogs = new File(new_state_dir, "logs");
        if (oldlogs.exists() && !newlogs.exists()) {
            LOGGER.info("Moving log files to new location");
            new_state_dir.mkdirs();
            if (!oldlogs.renameTo(newlogs)) {
                throw new IOException("Could not move " + oldlogs.getAbsolutePath() + " to " + newlogs.getAbsolutePath());
            }
        }
    }

    public static void moveConfigAndStateFiles() throws IOException {
        File[] olddirs;
        File oldindex;
        LOGGER.info("Moving config and state files to new file structure");
        File web_inf_dir = new File(Settings.getContextPath() + "WEB-INF");
        File new_state_dir = new File(web_inf_dir, "state");
        new_state_dir.mkdirs();
        File oldcache = new File(web_inf_dir, "cache");
        if (oldcache.exists()) {
            LOGGER.info("Moving cache files to new location");
            File newcache = new File(new_state_dir, "cache");
            if (!oldcache.renameTo(newcache)) {
                throw new IOException("Could not move " + oldcache.getAbsolutePath() + " to " + newcache.getAbsolutePath());
            }
        }
        if ((oldindex = new File(web_inf_dir, "index")).exists()) {
            LOGGER.info("Moving index files to new location");
            File newindex = new File(new_state_dir, "index");
            if (!oldindex.renameTo(newindex)) {
                throw new IOException("Could not move " + oldindex.getAbsolutePath() + " to " + newindex.getAbsolutePath());
            }
        }
        File config_dir = new File(web_inf_dir, "config");
        File new_template_dir = new File(config_dir, "template");
        LOGGER.info("Moving template files to new location");
        File old_template_dir = new File(web_inf_dir, "template");
        for (File olddir : olddirs = old_template_dir.listFiles()) {
            if ("default".equals(olddir.getName()) || olddir.getName().startsWith("default.")) continue;
            LOGGER.info("Moving directory " + olddir.getAbsolutePath());
            File newdir = new File(new_template_dir, olddir.getName());
            File[] oldfiles = olddir.listFiles();
            if (oldfiles != null) {
                for (File oldfile : oldfiles) {
                    UpdateConfigs.moveTemplateFiles(oldfile, new File(newdir, oldfile.getName().toLowerCase()));
                }
            }
            if (olddir.delete()) continue;
            throw new IOException("Could not remove " + olddir.getAbsolutePath());
        }
        LOGGER.info("Moving woconfig files to new location");
        File old_woconfig_dir = new File(Settings.getContextPath() + "woconfig");
        if (old_woconfig_dir.exists() && old_woconfig_dir.isDirectory()) {
            for (File olddir : olddirs = old_woconfig_dir.listFiles()) {
                File[] subdirs;
                File psmldir;
                if (!olddir.isDirectory()) continue;
                LOGGER.info("Moving directory " + olddir.getAbsolutePath());
                String project = olddir.getName();
                File orgdir = new File(olddir, "organization");
                if (orgdir.exists() && orgdir.isDirectory()) {
                    File newdir = new File(new_template_dir, project + File.separator + "organization" + File.separator + "style");
                    UpdateConfigs.moveTemplateFiles(orgdir, newdir);
                }
                if ((psmldir = new File(olddir, "psml")).exists() && psmldir.isDirectory()) {
                    File[] typedirs;
                    for (File typedir : typedirs = psmldir.listFiles()) {
                        if (typedir.isDirectory()) {
                            String type = typedir.getName();
                            File newdir = new File(new_template_dir, project + File.separator + "psml" + File.separator + type + File.separator + "style");
                            UpdateConfigs.moveTemplateFiles(typedir, newdir);
                            continue;
                        }
                        LOGGER.warn("Non-standard file may need to moved manually " + typedir.getAbsolutePath());
                    }
                }
                for (File file : subdirs = olddir.listFiles()) {
                    if (file.isDirectory() && (".history".equals(file.getName()) || "organization".equals(file.getName()) || "psml".equals(file.getName()))) continue;
                    LOGGER.warn("Non-standard " + (file.isDirectory() ? "folder" : "file") + " may need to moved manually " + file.getAbsolutePath());
                }
            }
        }
        LOGGER.info("Moving publish template files to new location");
        File old_publish_dir = new File(Settings.getContextPath() + ".." + File.separator + "ps-publisher" + File.separator + "WEB-INF" + File.separator + "template");
        if (old_publish_dir.exists() && old_publish_dir.isDirectory()) {
            for (File olddir : olddirs = old_publish_dir.listFiles()) {
                if ("default".equals(olddir.getName())) continue;
                UpdateConfigs.moveTemplateFiles(olddir, new File(new_template_dir, olddir.getName()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void moveTemplateFiles(File oldfile, File newfile) throws IOException {
        File[] files;
        if (!oldfile.isDirectory()) {
            if (!newfile.getParentFile().exists() && !newfile.getParentFile().mkdirs()) {
                throw new IOException("Could not create " + newfile.getParentFile().getAbsolutePath());
            }
            if (!newfile.exists()) {
                if (oldfile.renameTo(newfile)) return;
                throw new IOException("Could not move " + oldfile.getAbsolutePath() + " to " + newfile.getAbsolutePath());
            }
            String[] filename = URIRule.getFilename((String)newfile.getName());
            File newfile2 = new File(newfile.getParentFile(), filename[0] + "-2" + filename[1]);
            if (newfile2.exists()) throw new IOException("Could not move " + oldfile.getAbsolutePath() + " as it would clash with " + newfile2.getAbsolutePath());
            if (!oldfile.renameTo(newfile2)) {
                throw new IOException("Could not move " + oldfile.getAbsolutePath() + " to " + newfile2.getAbsolutePath());
            }
            LOGGER.warn("Renamed " + oldfile.getAbsolutePath() + " to " + newfile2.getAbsolutePath() + " as that file already exists in new location.");
            return;
        }
        LOGGER.info("Moving directory " + oldfile.getAbsolutePath());
        if (!newfile.exists() && !newfile.mkdirs()) {
            throw new IOException("Could not create " + newfile.getAbsolutePath());
        }
        for (File file : files = oldfile.listFiles()) {
            String name = file.getName();
            if (".history".equals(newfile.getName())) {
                name = name.toLowerCase();
            }
            if (newfile.getAbsolutePath().endsWith(EXPORT_CONFIG_PATH) && ("pdf-export-config.xml".equals(name) || "word-export-config.xml".equals(name) || "word-export-template.docx".equals(name)) || newfile.getAbsolutePath().endsWith(UPLOAD_CONFIG_PATH) && "word-import-config.xml".equals(name)) {
                try {
                    if (!new File(oldfile.getParentFile(), name).exists()) {
                        Files.copy((File)file, (File)new File(newfile.getParentFile(), name), (CopyOption[])new CopyOption[0]);
                    } else {
                        LOGGER.warn("Could not copy " + file.getAbsolutePath() + " to " + newfile.getParentFile().getAbsolutePath() + " because that file already exists.");
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Could not copy " + file.getAbsolutePath() + " to " + newfile.getParentFile().getAbsolutePath() + " because: " + ex.getMessage());
                }
            }
            UpdateConfigs.moveTemplateFiles(file, new File(newfile, name));
        }
        if (oldfile.delete()) return;
        throw new IOException("Could not remove " + oldfile.getAbsolutePath());
    }
}

