/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder;

import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.permission.AdminDatabaseCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.properties.DatabaseSettings;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class Query
extends HttpServlet {
    private static final long serialVersionUID = 8275191374805828628L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Database db;
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if ((db = WebRequest.getDatabase((HttpServletResponse)res)) == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Permissions perm = new Permissions();
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new AdminDatabaseCheck(req))) {
                tr.abort();
                return;
            }
            res.setContentType("text/html");
            PrintWriter out = res.getWriter();
            out.println("<HTML><HEAD>");
            out.println("<TITLE>SQL Query");
            out.println("</TITLE></HEAD><BODY>");
            out.println("<H1>SQL Query</H1>");
            out.println("<P><B>Enter your SQL SELECT commands below and click on submit.</B></P>");
            out.println("<P><B>NOTE: On Linux MySQL table names are case sensitive</B></P>");
            out.println("<form method=\"POST\" action=\"" + GlobalSettings.get((String)"servletPrefix") + "/com.pageseeder.Query\">");
            out.println("  <p><textarea rows=\"9\" name=\"sql\" cols=\"62\"></textarea></p>");
            out.println("  <input type=\"hidden\" name=\"anti-csrf-token\" value=\"" + CSRF.getAntiCSRFToken((HttpSession)req.getSession(false)) + "\">");
            out.println("  <p><input type=\"submit\" value=\"Submit\" name=\"B1\"></p>");
            out.println("</form>");
            out.println("</BODY></HTML>");
            out.close();
            tr.commit();
        }
        catch (StartTransactionException ex) {
            req.setAttribute("javax.servlet.error.request_uri", (Object)req.getRequestURI());
            req.setAttribute("javax.servlet.error.servlet_name", (Object)this.getServletName());
            req.setAttribute("javax.servlet.error.exception", (Object)ex);
            res.sendError(500, "Failed to start the transaction: " + ex.getMessage());
        }
        catch (Exception ex) {
            tr.abort();
            req.setAttribute("javax.servlet.error.request_uri", (Object)req.getRequestURI());
            req.setAttribute("javax.servlet.error.servlet_name", (Object)this.getServletName());
            req.setAttribute("javax.servlet.error.exception", (Object)ex);
            res.sendError(500, "Unknown error: " + ex.getMessage());
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Database db;
        long start = System.currentTimeMillis();
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if ((db = WebRequest.getDatabase((HttpServletResponse)res)) == null) {
            return;
        }
        boolean isJDOQuery = "jdo".equals(req.getParameter("mode"));
        String sqlParameter = req.getParameter("sql");
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Permissions perm = new Permissions();
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new AdminDatabaseCheck(req))) {
                tr.abort();
                return;
            }
            if (!CSRF.validateAntiCSRFToken((HttpServletRequest)req)) {
                res.sendError(419, "Missing correct CSRF token");
                tr.abort();
                return;
            }
            res.setContentType("text/plain");
            PrintWriter out = res.getWriter();
            if (isJDOQuery) {
                if (!sqlParameter.toLowerCase().startsWith("select") || sqlParameter.contains(" into ")) {
                    out.println("Only SELECT queries are allowed");
                } else {
                    DatabaseQuery.executeSQLQuery((Database)db, (String)sqlParameter, (PrintWriter)out);
                }
            }
            tr.commit();
            WebUtilities.logAccess((HttpServletRequest)req, (int)200, (String)"query", (long)start, (AccessEvent.Permission)AccessEvent.Permission.ADMINISTRATOR);
        }
        catch (DatabaseException ex) {
            tr.abort();
            req.setAttribute("javax.servlet.error.request_uri", (Object)req.getRequestURI());
            req.setAttribute("javax.servlet.error.servlet_name", (Object)this.getServletName());
            req.setAttribute("javax.servlet.error.exception", (Object)ex);
            res.sendError(500, "Failed to communicate with Database: " + ex.getMessage());
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"query", (long)start, (AccessEvent.Permission)AccessEvent.Permission.ADMINISTRATOR);
        }
        finally {
            db.close();
        }
        if (!isJDOQuery) {
            try {
                PrintWriter out = res.getWriter();
                Query.execRawQuery(sqlParameter, out);
                out.flush();
                out.close();
            }
            catch (IOException | SQLException ex) {
                req.setAttribute("javax.servlet.error.request_uri", (Object)req.getRequestURI());
                req.setAttribute("javax.servlet.error.servlet_name", (Object)this.getServletName());
                req.setAttribute("javax.servlet.error.exception", (Object)ex);
                res.sendError(500, "Unknown error: " + ex.getMessage());
                WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"query", (long)start, (AccessEvent.Permission)AccessEvent.Permission.ADMINISTRATOR);
            }
        }
    }

    public String getServletInfo() {
        return "Executes SQL SELECT commands on PageSeeder database.";
    }

    private static void execRawQuery(String sqlParameter, PrintWriter out) throws SQLException {
        try {
            Class.forName(DatabaseSettings.get((String)"DBDriver")).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            ex.printStackTrace(out);
            return;
        }
        try (Connection con = Query.createConnection();){
            try (BufferedReader in = new BufferedReader(new StringReader(sqlParameter));){
                String line;
                while ((line = in.readLine()) != null) {
                    StringBuilder sql = new StringBuilder();
                    while (line != null && !line.isEmpty()) {
                        sql.append(line);
                        line = in.readLine();
                    }
                    if (sql.length() <= 0) continue;
                    Query.handleStatement(con, sql.toString(), out);
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    private static Connection createConnection() throws SQLException {
        String url = DatabaseSettings.get((String)"DBURL");
        String username = DatabaseSettings.get((String)"LoginName");
        String password = DatabaseSettings.getPassword();
        return DriverManager.getConnection(url, username, password);
    }

    private static void handleStatement(Connection con, String sql, PrintWriter out) throws SQLException {
        try (Statement s = con.createStatement();){
            if (!sql.toLowerCase().startsWith("select") || sql.contains(" into ")) {
                out.println("Only SELECT queries are allowed");
            } else {
                ResultSet rs = s.executeQuery(sql);
                ResultSetMetaData metaData = rs.getMetaData();
                int numCols = metaData.getColumnCount();
                for (int i = 1; i <= numCols; ++i) {
                    if (i > 1) {
                        out.print(",");
                    }
                    out.print(metaData.getColumnLabel(i));
                }
                out.println("");
                boolean more = rs.next();
                while (more) {
                    Query.printRow(rs, numCols, out);
                    more = rs.next();
                }
            }
        }
    }

    private static void printRow(ResultSet rs, int numCols, PrintWriter out) throws SQLException {
        for (int i = 1; i <= numCols; ++i) {
            if (i > 1) {
                out.print(",");
            }
            String value = rs.getString(i);
            out.print(value);
        }
        out.println("");
    }
}

