/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder;

import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.security.LockedAccountException;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.util.Cookies;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebTransaction;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.http.HttpRedirect;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Member;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.pageseeder.xmlwriter.XMLWriterImpl;

@PublicAPI
public final class Login
extends HttpServlet {
    private static final long serialVersionUID = -7379635146812149541L;
    private static final String USERNAME_PARAM = "login-username";
    private static final String PASSWORD_PARAM = "login-password";
    private static final String LOCATION_PARAM = "location";
    private static final String STATUS_ELEMENT = "status";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (WebUtilities.deprecatedError((HttpServletRequest)req, (HttpServletResponse)res, (String)"")) {
            return;
        }
        HttpSession session = req.getSession(false);
        WebTransaction wtr = session != null ? new WebTransaction(session, "Login", false) : null;
        String username = wtr != null ? (String)wtr.get(USERNAME_PARAM) : null;
        String action = req.getParameter("action");
        WebRequest wr = new WebRequest(req, res);
        Database db = wr.getDatabase();
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            res.setContentType("application/xml");
            res.setCharacterEncoding("UTF-8");
            XMLWriterImpl xml = new XMLWriterImpl((Writer)res.getWriter());
            xml.openElement("root", true);
            xml.element("servletname", ((Object)((Object)this)).getClass().getName());
            xml.element("lastusername", req.getParameter(USERNAME_PARAM));
            if ("logout".equals(action)) {
                Long memberid = SecurityUtils.getAuthenticatedMemberId((HttpServletRequest)req);
                if (memberid != null) {
                    UserDetailsManager user_manager = new UserDetailsManager();
                    xml.element("manager", Boolean.toString(MemberRule.isManager((Map)user_manager.get(db, memberid).flags())));
                }
                SecurityUtils.logout((Database)db, (HttpServletRequest)req, (HttpServletResponse)res);
                xml.element(STATUS_ELEMENT, "logout");
            } else if ("no_rights_final".equals(action)) {
                xml.element(STATUS_ELEMENT, "no_rights_final");
            } else if ("cancel".equals(action)) {
                if (wtr != null) {
                    wtr.remove("resourceCheck");
                    wtr.remove(LOCATION_PARAM);
                }
                xml.element(STATUS_ELEMENT, "cancel");
            } else if (username != null && "refresh".equals(action)) {
                SecurityUtils.updateUserDetails((HttpServletRequest)req);
                xml.element("action", "refresh");
                xml.element(STATUS_ELEMENT, "success");
            } else if (username != null) {
                if ("new_login".equals(action) && wtr != null) {
                    wtr.remove(LOCATION_PARAM);
                }
                xml.element(STATUS_ELEMENT, "logged_in");
                xml.element("username", username);
            } else if ("new_login".equals(action)) {
                if (wtr != null) {
                    wtr.remove(LOCATION_PARAM);
                }
                xml.element(STATUS_ELEMENT, "new_login");
                res.setStatus(401);
            } else if ("create_login".equals(action)) {
                xml.element(STATUS_ELEMENT, "create_login");
            } else {
                xml.element(STATUS_ELEMENT, "new_login");
                res.setStatus(401);
            }
            if (wtr != null && wtr.get(LOCATION_PARAM) != null) {
                xml.element(LOCATION_PARAM, wtr.get(LOCATION_PARAM).toString());
            }
            xml.closeElement();
            xml.flush();
            tr.commit();
        }
        catch (StartTransactionException ex) {
            wr.sendError(500, (Exception)((Object)ex));
        }
        catch (IOException ex) {
            wr.sendError((Exception)ex);
            tr.abort();
        }
        catch (DatabaseException ex) {
            tr.abort();
            wr.sendError(500, (Exception)((Object)ex));
        }
        finally {
            db.close();
            db = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if ("GET".equalsIgnoreCase((String)req.getAttribute("com.pageseeder.http_method"))) {
            this.doGet(req, res);
            return;
        }
        if (WebUtilities.deprecatedError((HttpServletRequest)req, (HttpServletResponse)res, (String)"")) {
            return;
        }
        WebRequest wreq = new WebRequest(req, res);
        HttpSession session = req.getSession(true);
        WebTransaction wtr = new WebTransaction(session, "Login", false);
        String location = req.getParameter(LOCATION_PARAM);
        if (location != null && location.startsWith("http")) {
            try {
                URI uri = URI.create(req.getRequestURI());
                uri.resolve(location);
            }
            catch (IllegalArgumentException ex) {
                location = null;
            }
        }
        res.setContentType("application/xml");
        res.setCharacterEncoding("UTF-8");
        XMLWriterImpl xml = new XMLWriterImpl((Writer)res.getWriter());
        if (session.isNew()) {
            try {
                xml.openElement("root", true);
                xml.element("title", "Cookies Must Be Enabled");
                xml.element(STATUS_ELEMENT, "error");
                xml.element("message", "To login cookies must be enabled in your browser. For details on how to do this click on Help. If cookies are already enabled in your browser try closing your browser, then open it and try logging in again.");
                xml.closeElement();
                xml.flush();
            }
            catch (IOException ex) {
                wreq.sendError(500, (Exception)ex);
            }
            return;
        }
        String username = req.getParameter(USERNAME_PARAM);
        String[] credentials = new String[]{username, req.getParameter(PASSWORD_PARAM)};
        String status = "failed";
        Database db = wreq.getDatabase();
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            boolean valid;
            tr.begin();
            Member activationMember = null;
            try {
                valid = SecurityUtils.checkPassword((Database)db, (String[])credentials, (String)SecurityUtils.getRemoteIP((HttpServletRequest)req));
            }
            catch (LockedAccountException ex) {
                try {
                    xml.openElement("root", true);
                    xml.element("title", "Locked account");
                    xml.element(STATUS_ELEMENT, "locked");
                    xml.element("message", "Your account has been locked due to incorrect logins, please try again later.");
                    xml.closeElement();
                    xml.flush();
                }
                catch (IOException ex2) {
                    wreq.sendError(500, (Exception)ex2);
                }
                tr.abort();
                db.close();
                db = null;
                return;
            }
            if (valid) {
                Member mem = DatabaseQuery.getMemberByUsername((Database)db, (String)credentials[0]);
                if (!MemberRule.isMemberActivated((Member)mem)) {
                    status = "activation_required";
                    activationMember = mem;
                } else if (MemberRule.isMemberDisabled((Member)mem)) {
                    status = "member_disabled";
                } else {
                    if (!CSRF.validateOriginReferer((HttpServletRequest)req, (Database)db)) {
                        wreq.sendError(403, "Missing correct CSRF token");
                        tr.abort();
                        return;
                    }
                    SecurityUtils.login((Database)db, (String)credentials[0], (HttpServletRequest)req, (boolean)true);
                    status = "success";
                    Cookies.removeCookie((HttpServletResponse)res, (String)"pslogin.cookie1", (String)"/");
                    Cookies.removeCookie((HttpServletResponse)res, (String)"pslogin.cookie2", (String)"/");
                    if ("yes".equals(req.getParameter("remember"))) {
                        SecurityUtils.setRememberMeCookie((Database)db, (HttpServletRequest)req, (HttpServletResponse)res, (Member)mem);
                    }
                    if (location != null) {
                        HttpRedirect.sendRedirect((HttpServletRequest)req, (HttpServletResponse)res, (String)location);
                        tr.commit();
                        return;
                    }
                }
            }
            try {
                xml.openElement("root", true);
                xml.element("servletname", ((Object)((Object)this)).getClass().getName());
                xml.element(STATUS_ELEMENT, status);
                xml.element("lastusername", username);
                if (wtr.get(LOCATION_PARAM) != null) {
                    xml.element(LOCATION_PARAM, wtr.get(LOCATION_PARAM).toString());
                }
                if (activationMember != null) {
                    xml.openElement("member", true);
                    xml.element("id", activationMember.getId().toString());
                    xml.element("username", activationMember.getUsername());
                    xml.element("firstname", activationMember.getFirstName());
                    xml.element("surname", activationMember.getSurname());
                    xml.closeElement();
                    xml.element("email", activationMember.getEmail());
                }
                xml.closeElement();
                xml.flush();
            }
            catch (IOException ex) {
                wreq.sendError(500, (Exception)ex);
            }
            tr.commit();
        }
        catch (StartTransactionException ex) {
            wreq.sendError(500, (Exception)((Object)ex));
        }
        catch (DatabaseException ex) {
            tr.abort();
            wreq.sendError(500, (Exception)((Object)ex));
        }
        finally {
            db.close();
            db = null;
        }
    }

    public String getServletInfo() {
        return "Displays and processes a login form.";
    }
}

