/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder;

import com.pageseeder.Initialize;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Output(types={OutputType.JSON, OutputType.XML})
@PublicAPI
public final class DBMonitor
extends HttpServlet {
    private static final long serialVersionUID = -4731158832019279092L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        UniversalPrinter out = WebUtilities.getUniversalPrinter((HttpServletRequest)req, (HttpServletResponse)res);
        if (!Initialize.initThread.isFinished()) {
            out.startObject("monitor");
            Initialize.initThread.print((OutputPrinter)out);
            out.endObject();
            out.flush();
            return;
        }
        Database db = WebRequest.getDatabase((HttpServletResponse)res);
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Group grp = DatabaseQuery.getGroupByName((Database)db, (String)"admin");
            if (grp == null) {
                res.sendError(502, "Group admin not found.");
            } else {
                out.startObject("monitor");
                out.field("message", "Connected to database and accessed a group OK");
                out.endObject();
                out.flush();
            }
            tr.commit();
        }
        catch (StartTransactionException ex) {
            res.sendError(502, ex.getMessage());
        }
        catch (DatabaseException ex) {
            res.sendError(502, ex.getMessage());
            tr.abort();
        }
        catch (Exception ex) {
            res.sendError(500, ex.getMessage());
            tr.abort();
        }
        finally {
            db.close();
            db = null;
        }
    }

    public String getServletInfo() {
        return "Try's to connect to the database";
    }
}

