/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.pdf.util;

public final class XML {
    private static final int HT = 9;
    private static final int LF = 10;
    private static final int CR = 13;
    private static final int SP = 32;
    private static final int DEL = 127;
    private static final int APC = 159;

    private XML() {
    }

    public static void makeXMLSafe(String text, StringBuilder xml) {
        if (text != null) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (XML.isLegalXMLChar(c)) {
                    switch (c) {
                        case '>': {
                            xml.append("&gt;");
                            break;
                        }
                        case '<': {
                            xml.append("&lt;");
                            break;
                        }
                        case '&': {
                            xml.append("&amp;");
                            break;
                        }
                        default: {
                            xml.append(c);
                            break;
                        }
                    }
                    continue;
                }
                xml.append('?');
            }
        }
    }

    private static boolean isLegalXMLChar(char c) {
        return !(c < ' ' && c != '\t' && c != '\n' && c != '\r' || c >= '\u007f' && c <= '\u009f');
    }
}

