/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.aws;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Utils {
    static final Pattern ENCODED_CHARACTERS_PATTERN;

    private Utils() {
    }

    public static String hash(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(data);
            return Utils.toHex(hash);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("SHA-256 not supported", ex);
        }
    }

    public static String hash(String data) {
        return Utils.hash(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String toHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static String uriEncode(String value, boolean path) {
        String encoded = URLEncoder.encode(value, StandardCharsets.UTF_8);
        Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(encoded);
        StringBuilder buffer = new StringBuilder(encoded.length());
        while (matcher.find()) {
            String replacement = matcher.group(0);
            if ("+".equals(replacement)) {
                replacement = "%20";
            } else if ("*".equals(replacement)) {
                replacement = "%2A";
            } else if ("%7E".equals(replacement)) {
                replacement = "~";
            } else if (path && "%2F".equals(replacement)) {
                replacement = "/";
            }
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    static {
        String pattern = Pattern.quote("+") + "|" + Pattern.quote("*") + "|" + Pattern.quote("%7E") + "|" + Pattern.quote("%2F");
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern);
    }
}

