/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.aws;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import net.pageseeder.aws.Parameter;
import org.eclipse.jdt.annotation.Nullable;

public final class Parameters
extends AbstractCollection<Parameter>
implements Iterable<Parameter> {
    private static final Parameters EMPTY = new Parameters(new Parameter[0]);
    private final Parameter[] parameterList;

    private Parameters(Parameter[] parameters) {
        this.parameterList = parameters;
    }

    public static Parameters of(String name, String value) {
        return new Parameters(new Parameter[]{new Parameter(name, value)});
    }

    public static Parameters of(Parameter ... parameters) {
        return new Parameters(parameters);
    }

    public static Parameters fromMap(Map<String, ?> parameters) {
        Parameter[] params = new Parameter[parameters.size()];
        int i = 0;
        for (Map.Entry<String, ?> entry : parameters.entrySet()) {
            params[i++] = new Parameter(entry.getKey(), Objects.toString(entry.getValue()));
        }
        return new Parameters(params);
    }

    public static Parameters empty() {
        return EMPTY;
    }

    public @Nullable String getValue(String name) {
        Parameter p = this.get(name);
        return p != null ? p.value() : null;
    }

    public List<String> getValues(String name) {
        return Arrays.stream(this.parameterList).filter(p -> p.name().equals(name)).map(Parameter::value).collect(Collectors.toList());
    }

    public @Nullable Parameter get(String name) {
        for (Parameter p : this.parameterList) {
            if (!p.name().equals(name)) continue;
            return p;
        }
        return null;
    }

    public Parameters getAll(String name) {
        return Parameters.of(((Parameter[])Arrays.stream(this.parameterList).filter(p -> p.name().equals(name)).toArray(Parameter[]::new))[0]);
    }

    @Override
    public Iterator<Parameter> iterator() {
        return new Iterator<Parameter>(){
            private int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < Parameters.this.parameterList.length;
            }

            @Override
            public Parameter next() {
                if (this.currentIndex >= Parameters.this.parameterList.length) {
                    throw new NoSuchElementException();
                }
                return Parameters.this.parameterList[this.currentIndex++];
            }
        };
    }

    @Override
    public int size() {
        return this.parameterList.length;
    }

    public String toQueryString() {
        StringBuilder q = new StringBuilder();
        for (Parameter p : this.parameterList) {
            if (q.length() > 0) {
                q.append("&");
            }
            q.append(p.toQueryString());
        }
        return q.toString();
    }

    @Override
    public String toString() {
        return this.toQueryString();
    }

    public Parameters canonicalize() {
        Parameter[] params = Arrays.copyOf(this.parameterList, this.parameterList.length);
        Arrays.sort(params, Comparator.comparing(Parameter::encodedName));
        return new Parameters(params);
    }
}

