/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.aws;

import java.util.Objects;

public final class Header {
    private final String name;
    private final String value;
    private final boolean isSigned;

    public Header(String name, String value) {
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
        this.isSigned = true;
    }

    public Header(String name, String value, boolean isSigned) {
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
        this.isSigned = isSigned;
    }

    public String name() {
        return this.name;
    }

    public String lcName() {
        return this.name.toLowerCase();
    }

    public String value() {
        return this.value;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public String toCanonical() {
        return this.name.toLowerCase() + ":" + this.value.trim();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        return this.isSigned == header.isSigned && Objects.equals(this.name, header.name) && Objects.equals(this.value, header.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.isSigned);
    }

    public String toString() {
        return this.name + ":" + this.value;
    }
}

