/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth.authorizer;

import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.oauth.core.OAuthErrorResponse;
import com.pageseeder.base.oauth.core.OAuthErrorType;
import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.core.OAuthParameter;
import com.pageseeder.base.oauth.jwt.JWTAlgorithm;
import com.pageseeder.base.oauth.jwt.JWTClaimSet;
import com.pageseeder.base.oauth.model.AccessToken;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.oauth.model.AuthorizationCode;
import com.pageseeder.base.oauth.model.CodeManager;
import com.pageseeder.base.oauth.openid.ClaimsProvider;
import com.pageseeder.base.oauth.openid.IDToken;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.security.LockedAccountException;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.common.oauth.GrantType;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import com.pageseeder.db.oauth.Scope;
import com.pageseeder.oauth.authorizer.TokenRequest;
import com.pageseeder.oauth.authorizer.TokenResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenServlet
extends HttpServlet {
    private static final long serialVersionUID = 9193045986283724322L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenServlet.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try {
            this.token(req, res);
        }
        catch (RuntimeException ex) {
            TokenServlet.handleError(res, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void token(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Database db = WebRequest.getDatabase((HttpServletResponse)res);
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            TokenRequest oauth = TokenRequest.newInstance(req);
            String clientId = oauth.getClientId();
            Client client = OAuthQuery.getClientByIdentifier((Database)db, (String)clientId);
            String secret = oauth.getClientSecret();
            if (client == null || !client.isClientSecret(secret)) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.unauthorized_client, (String)"Incorrect credentials");
            }
            GrantType grantType = oauth.getGrantType();
            if (!TokenServlet.isAuthorizedClient(grantType, client)) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.unauthorized_client, (String)"Unauthorized for this grant type");
            }
            Set scopes = this.getDefaultScopes(oauth, client);
            boolean updatedScope = false;
            if (oauth.getParameter(OAuthParameter.scope) != null) {
                Set defaults = scopes;
                scopes = Scope.filterScopes((Collection)oauth.getScopes(), defaults);
                updatedScope = scopes.equals(oauth.getScopes());
            }
            long memberId = TokenServlet.getMemberId(db, grantType, client, oauth, SecurityUtils.getRemoteIP((HttpServletRequest)req));
            AccessTokenManager tokens = AccessTokenManager.singleton();
            AccessToken accessToken = tokens.issue(client, memberId, Scope.join((String)" ", (Set)scopes));
            Member mem = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
            if (mem != null) {
                mem.setLastLogin(new Date());
                SecurityLog.setupUser((Member)mem);
                SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)"OAuth token created");
            }
            TokenResponse response = new TokenResponse(200).setAccessToken(accessToken.token()).setExpiresIn(accessToken.maxAge(TimeUnit.SECONDS), TimeUnit.SECONDS).setTokenType("bearer");
            PersistentToken refreshToken = TokenServlet.getNewRefreshToken(db, oauth, memberId, client);
            if (refreshToken != null) {
                assert (refreshToken.getActualToken() != null);
                response.setRefreshToken(refreshToken.getActualToken());
            }
            if (updatedScope) {
                response.setScope(Scope.join((String)" ", (Set)scopes));
            }
            if (scopes.contains(Scope.OPENID)) {
                String subject = Long.toString(memberId);
                ClaimsProvider provider = new ClaimsProvider();
                JWTClaimSet claimSet = provider.getClaims(db, Long.valueOf(memberId), scopes);
                if (claimSet != null) {
                    IDToken token = new IDToken.Builder(claimSet).iss("https://self-issued.me").sub(subject).aud(client.getIdentifier()).exp(System.currentTimeMillis() / 1000L + 3600L).build(JWTAlgorithm.HS256, secret.getBytes());
                    response.setIDToken(token.token());
                }
            }
            tr.commit();
            response.toJSONMessage(res);
        }
        catch (OAuthException ex) {
            tr.abort();
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)ex.getMessage());
            OAuthErrorResponse r = new OAuthErrorResponse(400).error(ex);
            r.toJSONMessage(res);
        }
        catch (DatabaseException ex) {
            tr.abort();
            TokenServlet.handleError(res, (Exception)((Object)ex));
        }
        finally {
            db.close();
            db = null;
        }
    }

    private static boolean isAuthorizedClient(GrantType grantType, Client client) {
        switch (client.getGrantType()) {
            case authorization_code: {
                return GrantType.authorization_code == grantType || GrantType.refresh_token == grantType;
            }
            case client_credentials: {
                return GrantType.client_credentials == grantType;
            }
            case password: {
                return GrantType.password == grantType || GrantType.refresh_token == grantType;
            }
        }
        return false;
    }

    private static long getMemberId(Database db, GrantType grantType, Client client, TokenRequest oauth, String remoteIP) throws OAuthException, DatabaseException {
        if (GrantType.authorization_code == grantType) {
            CodeManager codes;
            AuthorizationCode ac;
            String code = oauth.getCode();
            String redirectURI = oauth.getRedirectURI();
            if (redirectURI == null) {
                redirectURI = client.getRedirectURI();
            }
            if ((ac = (codes = CodeManager.singleton()).consumeIfMatch(code, client.getIdentifier(), redirectURI)) == null) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_grant, (String)"Authorization code rejected");
            }
            return ac.getMemberId();
        }
        if (GrantType.refresh_token == grantType) {
            String code = oauth.getRefreshToken();
            PersistentToken refreshToken = OAuthQuery.getPersistentToken((Database)db, (String)code, (String)client.getIdentifier());
            if (refreshToken == null) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_grant, (String)"Refresh token rejected");
            }
            return refreshToken.getMemberId();
        }
        if (GrantType.client_credentials == grantType) {
            Member delegated = client.getMember();
            if (delegated == null) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_grant, (String)"Client not bound to any member");
            }
            return delegated.getId();
        }
        if (GrantType.password == grantType) {
            String username = oauth.getUsername();
            String password = oauth.getPassword();
            Member delegated = null;
            try {
                boolean ok = SecurityUtils.checkPassword((Database)db, (String[])new String[]{username, password}, (String)remoteIP);
                if (ok) {
                    delegated = username.indexOf(64) > 0 ? DatabaseQuery.getMemberByEmail((Database)db, (String)username) : DatabaseQuery.getMemberByUsername((Database)db, (String)username);
                }
            }
            catch (LockedAccountException ex) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_grant, (String)"Locked account");
            }
            if (delegated == null) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_grant, (String)"Invalid credentials");
            }
            if (MemberRule.isMemberDisabled(delegated)) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_grant, (String)"Member disabled");
            }
            return delegated.getId();
        }
        throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_grant, (String)"The provided authorization grant or refresh token is invalid");
    }

    private static @Nullable PersistentToken getNewRefreshToken(Database db, TokenRequest request, long memberId, Client client) throws OAuthException, DatabaseException {
        if (client.getRefreshTokenMaxAge(TimeUnit.MINUTES) <= 0L || client.getGrantType() == GrantType.client_credentials) {
            return null;
        }
        PersistentToken newRefreshToken = null;
        if (GrantType.authorization_code == request.getGrantType() || GrantType.password == request.getGrantType()) {
            Member member = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
            newRefreshToken = PersistentToken.issueRefreshToken((Database)db, (Client)client, (Member)member, (String)client.getScope());
        } else if (GrantType.refresh_token == request.getGrantType()) {
            String code = request.getRefreshToken();
            PersistentToken refreshToken = OAuthQuery.getPersistentToken((Database)db, (String)code, (String)client.getIdentifier());
            if (refreshToken == null) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_grant, (String)"Refresh token rejected");
            }
            long accessTokenExpires = System.currentTimeMillis() + client.getAccessTokenMaxAge(TimeUnit.MILLISECONDS) * 2L;
            boolean expiresSoon = refreshToken.hasExpiredAt(new Date(accessTokenExpires));
            if (expiresSoon) {
                newRefreshToken = PersistentToken.issueRefreshToken((Database)db, (Client)client, (Member)refreshToken.getMember(), (String)refreshToken.getScope());
            }
        }
        return newRefreshToken;
    }

    private static void handleError(HttpServletResponse res, Exception ex) throws IOException {
        LOGGER.error("Unable to issue token caused by Internal error: {}", (Object)ex.getMessage(), (Object)ex);
        OAuthException error = OAuthException.error((OAuthErrorType)OAuthErrorType.server_error);
        OAuthErrorResponse r = new OAuthErrorResponse(error.getResponseStatus()).error(error);
        r.toJSONMessage(res);
    }

    private Set<Scope> getDefaultScopes(TokenRequest oauth, Client client) {
        if (GrantType.authorization_code == oauth.getGrantType()) {
            String code;
            CodeManager codes = CodeManager.singleton();
            AuthorizationCode ac = codes.get(code = oauth.getCode());
            if (ac == null) {
                return Collections.emptySet();
            }
            return ac.getScopes();
        }
        return client.getScopes();
    }
}

