/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth.authorizer;

import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public final class RevocationServlet
extends HttpServlet {
    private static final long serialVersionUID = 3151690511827797283L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        @Nullable String token = req.getParameter("token");
        @Nullable String hint = req.getParameter("token_type_hint");
        if (token == null) {
            res.sendError(400);
            return;
        }
        Database db = WebRequest.getDatabase((HttpServletResponse)res);
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Permissions perm = new Permissions();
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new AuthenticatedInternalCheck())) {
                tr.abort();
                return;
            }
            if ("access_token".equals(hint)) {
                AccessTokenManager.singleton().revoke(token);
            } else if ("refresh_token".equals(hint)) {
                PersistentToken rt = OAuthQuery.getPersistentToken((Database)db, (String)token);
                if (rt != null) {
                    rt.delete(db);
                }
            } else {
                AccessTokenManager.singleton().revoke(token);
                PersistentToken rt = OAuthQuery.getPersistentToken((Database)db, (String)token);
                if (rt != null) {
                    rt.delete(db);
                }
            }
            res.sendError(501);
        }
        catch (DatabaseException ex) {
            tr.abort();
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Unable to revoke token", (Throwable)ex);
        }
        finally {
            db.close();
            db = null;
        }
    }
}

