/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.oauth.model.AccessToken;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import java.io.IOException;

@Requires(parameters={"token"})
@Output(types={OutputType.JSON, OutputType.XML})
public final class RevokeAccessToken
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageOAuthCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        AccessToken t;
        String token = req.getParameter((Parameter)StandardParameters.token);
        assert (token != null);
        AccessTokenManager manager = AccessTokenManager.singleton();
        if (token.contains("*")) {
            long memberId = req.getParameter((Parameter)StandardParameters.member, -1L);
            String clientId = req.getParameter((Parameter)StandardParameters.client, "");
            t = manager.revoke(token, clientId, memberId);
        } else {
            t = manager.revoke(token);
        }
        if (t != null) {
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("token-revocation", OutputPrinter.ObjectOption.XML_EMPTY);
            t.print((OutputPrinter)out, false);
            out.endObject();
            out.flush();
        } else {
            res.setError(GeneratorStatus.NOT_FOUND, "No matching access token");
        }
    }
}

