/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(parameters={"token"})
public class MakeAccessRequest
implements Generator,
SingleCheck {
    private static final List<String> ALLOWED_METHODS = Arrays.asList("GET", "PUT", "POST", "DELETE");

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageOAuthCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String token = req.getParameter((Parameter)StandardParameters.token);
        String method = req.getParameter((Parameter)StandardParameters.method, "GET").toUpperCase();
        URL url = this.getURLParameter(req, "url");
        String body = req.getParameter((Parameter)StandardParameters.body);
        if (url == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid URL");
            return;
        }
        if (!ALLOWED_METHODS.contains(method)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Method not allowed");
            return;
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("oauth-access");
        xml.openElement("request");
        xml.attribute("url", url.toString());
        xml.attribute("method", method);
        xml.attribute("bearer", token);
        xml.closeElement();
        Response response = this.getResource(url, token, method, body);
        response.toXML(xml);
        xml.closeElement();
    }

    private Response getResource(URL url, String token, String method, String body) {
        Response response = new Response();
        URLConnection c = null;
        try {
            c = url.openConnection();
            if (c instanceof HttpURLConnection) {
                HttpURLConnection connection = (HttpURLConnection)c;
                connection.addRequestProperty("Authorization", "Bearer " + token);
                connection.setRequestMethod(method);
                if (method.equals("POST") && body != null) {
                    byte[] bodyBytes = body.getBytes(StandardCharsets.UTF_8);
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                    connection.setRequestProperty("Content-Length", Integer.toString(bodyBytes.length));
                    connection.setDoInput(true);
                    OutputStream ost = connection.getOutputStream();
                    ost.write(bodyBytes);
                    ost.flush();
                    ost.close();
                }
                connection.connect();
                response.fetch(connection);
            }
        }
        catch (IOException ex) {
            response.grab(ex);
        }
        return response;
    }

    private @Nullable URL getURLParameter(GeneratorRequest req, String name) {
        try {
            return new URL(req.getParameter(name, ""));
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private static class Response
    implements XMLWritable {
        private int code = 0;
        private String message = "";
        private Map<String, List<String>> headers = Collections.emptyMap();
        private String body = "";

        private Response() {
        }

        void fetch(HttpURLConnection connection) throws IOException {
            this.code = connection.getResponseCode();
            this.message = connection.getResponseMessage();
            this.headers = connection.getHeaderFields();
            InputStream inputStream = this.code >= 400 ? connection.getErrorStream() : connection.getInputStream();
            this.body = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }

        void grab(Exception ex) {
            this.code = -1;
            this.message = ex.getMessage();
            StringWriter out = new StringWriter();
            PrintWriter w = new PrintWriter(out);
            ex.printStackTrace(w);
            w.flush();
            this.body = out.toString();
        }

        public void toXML(XMLWriter xml) throws IOException {
            xml.openElement("response");
            xml.attribute("http-code", this.code);
            xml.attribute("message", this.message);
            xml.openElement("headers");
            for (Map.Entry<String, List<String>> h : this.headers.entrySet()) {
                for (String v : h.getValue()) {
                    xml.openElement("header");
                    xml.attribute("name", h.getKey());
                    xml.attribute("value", v);
                    xml.closeElement();
                }
            }
            xml.closeElement();
            xml.writeText(this.body);
            xml.closeElement();
        }
    }
}

