/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewOAuthMemberCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import com.pageseeder.oauth.util.MemberErrorID;
import com.pageseeder.oauth.util.Members;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@Output(types={OutputType.JSON, OutputType.XML})
public final class ListPersistentTokensForMember
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Member mem;
        try {
            mem = Members.getMember(req);
        }
        catch (DatabaseException ex) {
            return new NoCheck();
        }
        return new ViewOAuthMemberCheck(mem);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Member mem = Members.getMember(req);
        if (mem == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
            return;
        }
        Database db = req.getDatabase();
        List tokens = OAuthQuery.listPersistentTokensByMemberID((Database)db, (Long)mem.getId());
        Member authmember = req.getAuthenticatedMember();
        boolean admin = false;
        if (authmember != null) {
            UserDetailsManager manager = new UserDetailsManager();
            UserDetails userdetails = manager.get(db, authmember.getId(), false);
            admin = MemberRule.isAdministrator((Map)userdetails.flags());
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("persistent-tokens");
        out.startCollection("persistent-tokens", OutputPrinter.CollectionOption.JSON_ONLY);
        for (PersistentToken token : tokens) {
            out.writePersistenToken(token, admin);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

