/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.oauth.model.AuthorizationCode;
import com.pageseeder.base.oauth.model.CodeManager;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.properties.GlobalSettings;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;

@Output(types={OutputType.JSON, OutputType.XML})
public final class ListAuthorizationCodes
implements Generator,
SingleCheck {
    private static final DateTimeFormatter ISO8601_DATETIME = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss[xxx]");

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageOAuthCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        CodeManager manager = CodeManager.singleton();
        Collection codes = manager.getCodes();
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("authorization-codes");
        out.field("manual-token-creation", GlobalSettings.getBoolean((String)"manualTokenCreation", (boolean)false));
        out.startCollection("authorization-codes", OutputPrinter.CollectionOption.JSON_ONLY);
        OffsetDateTime lastPurged = manager.getLastPurged();
        if (lastPurged != null) {
            out.field("last-purged", lastPurged.format(ISO8601_DATETIME));
        }
        for (AuthorizationCode code : codes) {
            code.print((OutputPrinter)out);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

