/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewOAuthMemberCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import java.io.IOException;

@Requires(parameters={"client"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetClient
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewOAuthMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String clientId = req.getParameter((Parameter)StandardParameters.client);
        Database db = req.getDatabase();
        Client client = OAuthQuery.getClient((Database)db, (String)clientId);
        if (client != null) {
            boolean isAdministrator = MemberRule.isAdministrator((Database)db, (Member)req.getAuthenticatedMember());
            boolean isSelf = req.getMember().getId().equals(client.getMember().getId());
            if (!isAdministrator && !isSelf) {
                res.setError(GeneratorStatus.FORBIDDEN, "The client is not owned by this member.");
                return;
            }
            UniversalPrinter out = res.getUniversalWriter();
            out.writeClient(client);
            out.flush();
        } else {
            res.setError(GeneratorStatus.NOT_FOUND, "Unable to find client");
        }
    }
}

