/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.oauth.model.AuthorizationCode;
import com.pageseeder.base.oauth.model.CodeManager;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(parameters={"client-id"})
public final class GetAuthorizationCodeInfo
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageOAuthCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String code = req.getParameter((Parameter)StandardParameters.code);
        CodeManager codes = CodeManager.singleton();
        AuthorizationCode authorization = codes.get(code);
        XMLWriter xml = res.getXMLWriter();
        if (authorization != null) {
            authorization.toXML(xml);
        } else {
            res.setError(GeneratorStatus.NOT_FOUND, "No matching authorization code");
        }
    }
}

